/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.github.GHException;
import org.kohsuke.github.RateLimitTarget;
import org.kohsuke.github.connector.GitHubConnectorRequest;

public class GitHubRequest
implements GitHubConnectorRequest {
    private static final Comparator<String> nullableCaseInsensitiveComparator = Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER);
    private static final List<String> METHODS_WITHOUT_BODY = Arrays.asList("GET", "DELETE");
    private final List<Entry> args;
    private final Map<String, List<String>> headers;
    private final Map<String, Object> injectedMappingValues;
    private final String apiUrl;
    private final String urlPath;
    private final String method;
    private final RateLimitTarget rateLimitTarget;
    private final byte[] body;
    private final boolean forceBody;
    private final URL url;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Basic argument validation")
    private GitHubRequest(@Nonnull List<Entry> args, @Nonnull Map<String, List<String>> headers, @Nonnull Map<String, Object> injectedMappingValues, @Nonnull String apiUrl, @Nonnull String urlPath, @Nonnull String method, @Nonnull RateLimitTarget rateLimitTarget, @CheckForNull byte[] body, boolean forceBody) {
        this.args = Collections.unmodifiableList(new ArrayList<Entry>(args));
        TreeMap caseInsensitiveMap = new TreeMap(nullableCaseInsensitiveComparator);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            caseInsensitiveMap.put(entry.getKey(), Collections.unmodifiableList(new ArrayList(entry.getValue())));
        }
        this.headers = Collections.unmodifiableMap(caseInsensitiveMap);
        this.injectedMappingValues = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(injectedMappingValues));
        this.apiUrl = apiUrl;
        this.urlPath = urlPath;
        this.method = method;
        this.rateLimitTarget = rateLimitTarget;
        this.body = body;
        this.forceBody = forceBody;
        String tailApiUrl = this.buildTailApiUrl();
        this.url = GitHubRequest.getApiURL(apiUrl, tailApiUrl);
    }

    static Builder<?> newBuilder() {
        return new Builder();
    }

    @Nonnull
    static URL getApiURL(String apiUrl, String tailApiUrl) {
        try {
            if (!tailApiUrl.startsWith("/")) {
                apiUrl = "";
            } else if ("github.com".equals(apiUrl)) {
                apiUrl = "https://api.github.com";
            }
            return new URI(apiUrl + tailApiUrl).toURL();
        }
        catch (Exception e) {
            throw new GHException("Unable to build GitHub API URL", e);
        }
    }

    static String transformEnum(Enum<?> en) {
        return en.toString().toLowerCase(Locale.ENGLISH).replace('_', '-');
    }

    @Override
    @Nonnull
    public String method() {
        return this.method;
    }

    @Nonnull
    public RateLimitTarget rateLimitTarget() {
        return this.rateLimitTarget;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Already unmodifiable")
    public List<Entry> args() {
        return this.args;
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Unmodifiable Map of unmodifiable lists")
    public Map<String, List<String>> allHeaders() {
        return this.headers;
    }

    @Override
    @CheckForNull
    public String header(String name) {
        List<String> values = this.headers.get(name);
        if (values != null) {
            return values.get(0);
        }
        return null;
    }

    @Nonnull
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Already unmodifiable")
    public Map<String, Object> injectedMappingValues() {
        return this.injectedMappingValues;
    }

    @Nonnull
    public String apiUrl() {
        return this.apiUrl;
    }

    @Nonnull
    public String urlPath() {
        return this.urlPath;
    }

    @Override
    public String contentType() {
        return this.header("Content-type");
    }

    @Override
    @CheckForNull
    public InputStream body() {
        return this.body != null ? new ByteArrayInputStream(this.body) : null;
    }

    @Override
    @Nonnull
    public URL url() {
        return this.url;
    }

    @Override
    public boolean hasBody() {
        return this.forceBody || !METHODS_WITHOUT_BODY.contains(this.method);
    }

    Builder<?> toBuilder() {
        return new Builder(this.args, this.headers, this.injectedMappingValues, this.apiUrl, this.urlPath, this.method, this.rateLimitTarget, this.body, this.forceBody);
    }

    private String buildTailApiUrl() {
        Object tailApiUrl = this.urlPath;
        if (!this.hasBody() && !this.args.isEmpty() && ((String)tailApiUrl).startsWith("/")) {
            try {
                StringBuilder argString = new StringBuilder();
                boolean questionMarkFound = ((String)tailApiUrl).indexOf(63) != -1;
                argString.append(questionMarkFound ? (char)'&' : '?');
                ListIterator<Entry> it = this.args.listIterator();
                while (it.hasNext()) {
                    Entry arg = (Entry)it.next();
                    argString.append(URLEncoder.encode(arg.key, StandardCharsets.UTF_8.name()));
                    argString.append('=');
                    argString.append(URLEncoder.encode(arg.value.toString(), StandardCharsets.UTF_8.name()));
                    if (!it.hasNext()) continue;
                    argString.append('&');
                }
                tailApiUrl = (String)tailApiUrl + argString;
            }
            catch (UnsupportedEncodingException e) {
                throw new GHException("UTF-8 encoding required", e);
            }
        }
        return tailApiUrl;
    }

    private static String urlPathEncode(String value) {
        try {
            return new URI(null, null, value, null, null).toASCIIString();
        }
        catch (URISyntaxException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static class Builder<B extends Builder<B>> {
        @Nonnull
        private final List<Entry> args;
        @Nonnull
        private final Map<String, List<String>> headers;
        @Nonnull
        private final Map<String, Object> injectedMappingValues;
        @Nonnull
        private String apiUrl;
        @Nonnull
        private String urlPath;
        @Nonnull
        private String method;
        @Nonnull
        private RateLimitTarget rateLimitTarget;
        private byte[] body;
        private boolean forceBody;

        protected Builder() {
            this(new ArrayList<Entry>(), new TreeMap<String, List<String>>(nullableCaseInsensitiveComparator), new LinkedHashMap<String, Object>(), "https://api.github.com", "/", "GET", RateLimitTarget.CORE, null, false);
        }

        private Builder(@Nonnull List<Entry> args, @Nonnull Map<String, List<String>> headers, @Nonnull Map<String, Object> injectedMappingValues, @Nonnull String apiUrl, @Nonnull String urlPath, @Nonnull String method, @Nonnull RateLimitTarget rateLimitTarget, @CheckForNull byte[] body, boolean forceBody) {
            this.args = new ArrayList<Entry>(args);
            TreeMap<String, List<String>> caseInsensitiveMap = new TreeMap<String, List<String>>(nullableCaseInsensitiveComparator);
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                caseInsensitiveMap.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
            this.headers = caseInsensitiveMap;
            this.injectedMappingValues = new LinkedHashMap<String, Object>(injectedMappingValues);
            this.apiUrl = apiUrl;
            this.urlPath = urlPath;
            this.method = method;
            this.rateLimitTarget = rateLimitTarget;
            this.body = body;
            this.forceBody = forceBody;
        }

        public GitHubRequest build() {
            return new GitHubRequest(this.args, this.headers, this.injectedMappingValues, this.apiUrl, this.urlPath, this.method, this.rateLimitTarget, this.body, this.forceBody);
        }

        public B withApiUrl(String url) {
            this.apiUrl = url;
            return (B)this;
        }

        public B removeHeader(String name) {
            this.headers.remove(name);
            return (B)this;
        }

        public B setHeader(String name, String value) {
            ArrayList<String> field = new ArrayList<String>();
            field.add(value);
            this.headers.put(name, field);
            return (B)this;
        }

        public B withHeader(String name, String value) {
            List<String> field = this.headers.get(name);
            if (field == null) {
                this.setHeader(name, value);
            } else {
                field.add(value);
            }
            return (B)this;
        }

        public B injectMappingValue(@NonNull Object value) {
            return this.injectMappingValue(value.getClass().getName(), value);
        }

        public B injectMappingValue(@NonNull String name, Object value) {
            this.injectedMappingValues.put(name, value);
            return (B)this;
        }

        public B withAccept(String name) {
            return this.withHeader("Accept", name);
        }

        public B with(Map<String, Object> map) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                this.with(entry.getKey(), entry.getValue());
            }
            return (B)this;
        }

        public B with(String key, int value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, long value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, boolean value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Enum<?> e) {
            if (e == null) {
                return this.with(key, (Object)null);
            }
            return this.with(key, GitHubRequest.transformEnum(e));
        }

        public B with(String key, String value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Collection<?> value) {
            return this.with(key, (Object)value);
        }

        public B with(String key, Map<?, ?> value) {
            return this.with(key, (Object)value);
        }

        public B with(@WillClose InputStream body) throws IOException {
            this.body = IOUtils.toByteArray((InputStream)body);
            IOUtils.closeQuietly((InputStream)body);
            return (B)this;
        }

        public B withNullable(String key, Object value) {
            this.args.add(new Entry(key, value));
            return (B)this;
        }

        public B with(String key, Object value) {
            if (value != null) {
                this.args.add(new Entry(key, value));
            }
            return (B)this;
        }

        public B set(String key, Object value) {
            this.remove(key);
            return this.with(key, value);
        }

        public B remove(String key) {
            int index = 0;
            while (index < this.args.size()) {
                if (this.args.get((int)index).key.equals(key)) {
                    this.args.remove(index);
                    continue;
                }
                ++index;
            }
            return (B)this;
        }

        public B method(@Nonnull String method) {
            this.method = method;
            return (B)this;
        }

        public B rateLimit(@Nonnull RateLimitTarget rateLimitTarget) {
            this.rateLimitTarget = rateLimitTarget;
            return (B)this;
        }

        public B contentType(String contentType) {
            this.setHeader("Content-type", contentType);
            return (B)this;
        }

        B setRawUrlPath(@Nonnull String rawUrlPath) {
            Objects.requireNonNull(rawUrlPath);
            if (!rawUrlPath.startsWith("http")) {
                throw new GHException("Raw URL must start with 'http'");
            }
            this.urlPath = rawUrlPath;
            return (B)this;
        }

        public B withUrlPath(@Nonnull String urlPath, String ... urlPathItems) {
            if (urlPathItems.length == 0 && !urlPath.startsWith("/")) {
                return this.setRawUrlPath(urlPath);
            }
            if (!this.urlPath.startsWith("/")) {
                throw new GHException("Cannot append to url path after setting a full url");
            }
            Object tailUrlPath = urlPath;
            if (urlPathItems.length != 0) {
                tailUrlPath = (String)tailUrlPath + "/" + String.join((CharSequence)"/", urlPathItems);
            }
            tailUrlPath = StringUtils.prependIfMissing((String)tailUrlPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            this.urlPath = GitHubRequest.urlPathEncode((String)tailUrlPath);
            return (B)this;
        }

        public B inBody() {
            this.forceBody = true;
            return (B)this;
        }
    }

    protected static class Entry {
        final String key;
        final Object value;

        protected Entry(String key, Object value) {
            this.key = key;
            this.value = value;
        }
    }
}

