/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHException;
import org.kohsuke.github.GHFork;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SearchResult;

public class GHRepositorySearchBuilder
extends GHSearchBuilder<GHRepository> {
    GHRepositorySearchBuilder(GitHub root) {
        super(root, RepositorySearchResult.class);
    }

    public GHRepositorySearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    GHRepositorySearchBuilder q(String qualifier, String value) {
        super.q(qualifier, value);
        return this;
    }

    public GHRepositorySearchBuilder in(String v) {
        return this.q("in:" + v);
    }

    public GHRepositorySearchBuilder size(String v) {
        return this.q("size:" + v);
    }

    public GHRepositorySearchBuilder fork(GHFork fork) {
        return this.q("fork", fork.toString());
    }

    public GHRepositorySearchBuilder visibility(GHRepository.Visibility visibility) {
        if (visibility == GHRepository.Visibility.UNKNOWN) {
            throw new GHException("UNKNOWN is a placeholder for unexpected values encountered when reading data. It cannot be passed as a search parameter.");
        }
        return this.q("is:" + String.valueOf((Object)visibility));
    }

    public GHRepositorySearchBuilder created(String v) {
        return this.q("created:" + v);
    }

    public GHRepositorySearchBuilder pushed(String v) {
        return this.q("pushed:" + v);
    }

    public GHRepositorySearchBuilder user(String v) {
        return this.q("user:" + v);
    }

    public GHRepositorySearchBuilder repo(String v) {
        return this.q("repo:" + v);
    }

    public GHRepositorySearchBuilder language(String v) {
        return this.q("language:" + v);
    }

    public GHRepositorySearchBuilder stars(String v) {
        return this.q("stars:" + v);
    }

    public GHRepositorySearchBuilder topic(String v) {
        return this.q("topic:" + v);
    }

    public GHRepositorySearchBuilder org(String v) {
        return this.q("org:" + v);
    }

    public GHRepositorySearchBuilder order(GHDirection v) {
        this.req.with("order", v);
        return this;
    }

    public GHRepositorySearchBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    @Override
    protected String getApiUrl() {
        return "/search/repositories";
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
    private static class RepositorySearchResult
    extends SearchResult<GHRepository> {
        private GHRepository[] items;

        private RepositorySearchResult() {
        }

        GHRepository[] getItems(GitHub root) {
            for (GHRepository gHRepository : this.items) {
            }
            return this.items;
        }
    }

    public static enum Sort {
        STARS,
        FORKS,
        UPDATED;

    }
}

