/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubAbuseLimitHandler;
import org.kohsuke.github.GitHubRateLimitChecker;
import org.kohsuke.github.GitHubRateLimitHandler;
import org.kohsuke.github.RateLimitChecker;
import org.kohsuke.github.RateLimitTarget;
import org.kohsuke.github.authorization.AuthorizationProvider;
import org.kohsuke.github.authorization.ImmutableAuthorizationProvider;
import org.kohsuke.github.connector.GitHubConnector;

public class GitHubBuilder
implements Cloneable {
    static File HOME_DIRECTORY = null;
    String endpoint = "https://api.github.com";
    private GitHubConnector connector;
    private GitHubRateLimitHandler rateLimitHandler = GitHubRateLimitHandler.WAIT;
    private GitHubAbuseLimitHandler abuseLimitHandler = GitHubAbuseLimitHandler.WAIT;
    private GitHubRateLimitChecker rateLimitChecker = new GitHubRateLimitChecker();
    AuthorizationProvider authorizationProvider = AuthorizationProvider.ANONYMOUS;

    static GitHubBuilder fromCredentials() throws IOException {
        FileNotFoundException cause = null;
        GitHubBuilder builder = null;
        builder = GitHubBuilder.fromEnvironment();
        if (builder.authorizationProvider != AuthorizationProvider.ANONYMOUS) {
            return builder;
        }
        try {
            builder = GitHubBuilder.fromPropertyFile();
            if (builder.authorizationProvider != AuthorizationProvider.ANONYMOUS) {
                return builder;
            }
        }
        catch (FileNotFoundException e) {
            cause = e;
        }
        throw (IOException)new IOException("Failed to resolve credentials from ~/.github or the environment.").initCause(cause);
    }

    private static void loadIfSet(String envName, Properties p, String propName) {
        String v = System.getenv(envName);
        if (v != null) {
            p.put(propName, v);
        }
    }

    public static GitHubBuilder fromEnvironment() {
        Properties props = new Properties();
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            String name = e.getKey().toLowerCase(Locale.ENGLISH);
            if (name.startsWith("github_")) {
                name = name.substring(7);
            }
            props.put(name, e.getValue());
        }
        return GitHubBuilder.fromProperties(props);
    }

    public static GitHubBuilder fromPropertyFile() throws IOException {
        File homeDir = HOME_DIRECTORY != null ? HOME_DIRECTORY : new File(System.getProperty("user.home"));
        File propertyFile = new File(homeDir, ".github");
        return GitHubBuilder.fromPropertyFile(propertyFile.getPath());
    }

    public static GitHubBuilder fromPropertyFile(String propertyFileName) throws IOException {
        Properties props = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertyFileName);
            props.load(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return GitHubBuilder.fromProperties(props);
    }

    public static GitHubBuilder fromProperties(Properties props) {
        GitHubBuilder self = new GitHubBuilder();
        String oauth = props.getProperty("oauth");
        String jwt = props.getProperty("jwt");
        String login = props.getProperty("login");
        if (oauth != null) {
            self.withOAuthToken(oauth, login);
        }
        if (jwt != null) {
            self.withJwtToken(jwt);
        }
        self.withEndpoint(props.getProperty("endpoint", "https://api.github.com"));
        return self;
    }

    public GitHubBuilder withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public GitHubBuilder withOAuthToken(String oauthToken) {
        return this.withAuthorizationProvider(ImmutableAuthorizationProvider.fromOauthToken(oauthToken));
    }

    public GitHubBuilder withOAuthToken(String oauthToken, String user) {
        return this.withAuthorizationProvider(ImmutableAuthorizationProvider.fromOauthToken(oauthToken, user));
    }

    public GitHubBuilder withAuthorizationProvider(AuthorizationProvider authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
        return this;
    }

    public GitHubBuilder withAppInstallationToken(String appInstallationToken) {
        return this.withAuthorizationProvider(ImmutableAuthorizationProvider.fromAppInstallationToken(appInstallationToken));
    }

    public GitHubBuilder withJwtToken(String jwtToken) {
        return this.withAuthorizationProvider(ImmutableAuthorizationProvider.fromJwtToken(jwtToken));
    }

    public GitHubBuilder withConnector(GitHubConnector connector) {
        this.connector = connector;
        return this;
    }

    public GitHubBuilder withRateLimitHandler(GitHubRateLimitHandler handler) {
        this.rateLimitHandler = handler;
        return this;
    }

    public GitHubBuilder withAbuseLimitHandler(GitHubAbuseLimitHandler handler) {
        this.abuseLimitHandler = handler;
        return this;
    }

    public GitHubBuilder withRateLimitChecker(@Nonnull RateLimitChecker coreRateLimitChecker) {
        return this.withRateLimitChecker(coreRateLimitChecker, RateLimitTarget.CORE);
    }

    public GitHubBuilder withRateLimitChecker(@Nonnull RateLimitChecker rateLimitChecker, @Nonnull RateLimitTarget rateLimitTarget) {
        this.rateLimitChecker = this.rateLimitChecker.with(rateLimitChecker, rateLimitTarget);
        return this;
    }

    public GitHub build() throws IOException {
        return new GitHub(this.endpoint, this.connector, this.rateLimitHandler, this.abuseLimitHandler, this.rateLimitChecker, this.authorizationProvider);
    }

    public GitHubBuilder clone() {
        try {
            return (GitHubBuilder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone should be supported", e);
        }
    }
}

