/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHIssue;
import org.kohsuke.github.GHIssueState;
import org.kohsuke.github.GHQueryBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public abstract class GHIssueQueryBuilder
extends GHQueryBuilder<GHIssue> {
    private final List<String> labels = new ArrayList<String>();

    GHIssueQueryBuilder(GitHub root) {
        super(root);
    }

    public GHIssueQueryBuilder state(GHIssueState state) {
        this.req.with("state", state);
        return this;
    }

    public GHIssueQueryBuilder label(String label) {
        if (label != null && !label.trim().isEmpty()) {
            this.labels.add(label);
            this.req.with("labels", String.join((CharSequence)",", this.labels));
        }
        return this;
    }

    public GHIssueQueryBuilder sort(Sort sort) {
        this.req.with("sort", sort);
        return this;
    }

    public GHIssueQueryBuilder direction(GHDirection direction) {
        this.req.with("direction", direction);
        return this;
    }

    @Deprecated
    public GHIssueQueryBuilder since(Date date) {
        return this.since(GitHubClient.toInstantOrNull(date));
    }

    public GHIssueQueryBuilder since(Instant date) {
        this.req.with("since", GitHubClient.printInstant(date));
        return this;
    }

    public GHIssueQueryBuilder since(long timestamp) {
        return this.since(new Date(timestamp));
    }

    public GHIssueQueryBuilder pageSize(int pageSize) {
        this.req.with("per_page", pageSize);
        return this;
    }

    public abstract String getApiUrl();

    public static class ForRepository
    extends GHIssueQueryBuilder {
        private final GHRepository repo;

        ForRepository(GHRepository repo) {
            super(repo.root());
            this.repo = repo;
        }

        public ForRepository milestone(String milestone) {
            this.req.with("milestone", milestone);
            return this;
        }

        public ForRepository assignee(String assignee) {
            this.req.with("assignee", assignee);
            return this;
        }

        public ForRepository creator(String creator) {
            this.req.with("creator", creator);
            return this;
        }

        public ForRepository mentioned(String mentioned) {
            this.req.with("mentioned", mentioned);
            return this;
        }

        @Override
        public String getApiUrl() {
            return this.repo.getApiTailUrl("issues");
        }

        @Override
        public PagedIterable<GHIssue> list() {
            return ((Requester)this.req.withUrlPath(this.getApiUrl(), new String[0])).toIterable(GHIssue[].class, item -> item.wrap(this.repo));
        }
    }

    public static enum Sort {
        CREATED,
        UPDATED,
        COMMENTS;

    }
}

