/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.kohsuke.github.BetaApi;
import org.kohsuke.github.GHLabelBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHLabel
extends GitHubInteractiveObject {
    private long id;
    private String nodeId;
    @JsonProperty(value="default")
    private boolean isDefault;
    @Nonnull
    private String url = "";
    @Nonnull
    private String name = "";
    @Nonnull
    private String color = "";
    @CheckForNull
    private String description = null;

    @JsonCreator
    private GHLabel(@JacksonInject @Nonnull GitHub root) {
    }

    @Nonnull
    GitHub getApiRoot() {
        return Objects.requireNonNull(this.root());
    }

    public long getId() {
        return this.id;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public String getColor() {
        return this.color;
    }

    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    static Collection<String> toNames(Collection<GHLabel> labels) {
        ArrayList<String> r = new ArrayList<String>();
        for (GHLabel l : labels) {
            r.add(l.getName());
        }
        return r;
    }

    @BetaApi
    static Creator create(GHRepository repository) {
        return new Creator(repository);
    }

    static GHLabel read(@Nonnull GHRepository repository, @Nonnull String name) throws IOException {
        return ((Requester)repository.root().createRequest().withUrlPath(repository.getApiTailUrl("labels"), name)).fetch(GHLabel.class);
    }

    static PagedIterable<GHLabel> readAll(@Nonnull GHRepository repository) {
        return ((Requester)repository.root().createRequest().withUrlPath(repository.getApiTailUrl("labels"), new String[0])).toIterable(GHLabel[].class, null);
    }

    @BetaApi
    public Updater update() {
        return new Updater(this);
    }

    @BetaApi
    public Setter set() {
        return new Setter(this);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).setRawUrlPath(this.getUrl())).send();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GHLabel ghLabel = (GHLabel)o;
        return Objects.equals(this.url, ghLabel.url) && Objects.equals(this.name, ghLabel.name) && Objects.equals(this.color, ghLabel.color) && Objects.equals(this.description, ghLabel.description);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.name, this.color, this.description);
    }

    @BetaApi
    public static class Creator
    extends GHLabelBuilder<Creator> {
        private Creator(@Nonnull GHRepository repository) {
            super(Creator.class, repository.root(), null);
            ((Requester)this.requester.method("POST")).withUrlPath(repository.getApiTailUrl("labels"), new String[0]);
        }
    }

    @BetaApi
    public static class Updater
    extends GHLabelBuilder<Updater> {
        private Updater(@Nonnull GHLabel base) {
            super(Updater.class, base.getApiRoot(), base);
            ((Requester)this.requester.method("PATCH")).setRawUrlPath(base.getUrl());
        }
    }

    @BetaApi
    public static class Setter
    extends GHLabelBuilder<GHLabel> {
        private Setter(@Nonnull GHLabel base) {
            super(GHLabel.class, base.getApiRoot(), base);
            ((Requester)this.requester.method("PATCH")).setRawUrlPath(base.getUrl());
        }
    }
}

