/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import javax.annotation.CheckForNull;
import org.kohsuke.github.GHCommentAuthorAssociation;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReviewCommentReactions;
import org.kohsuke.github.GHReaction;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Reactable;
import org.kohsuke.github.ReactionContent;
import org.kohsuke.github.Requester;
import org.kohsuke.github.internal.EnumUtils;

public class GHPullRequestReviewComment
extends GHObject
implements Reactable {
    GHPullRequest owner;
    private Long pullRequestReviewId = -1L;
    private String body;
    private GHUser user;
    private String path;
    private String htmlUrl;
    private String pullRequestUrl;
    private int position = -1;
    private int originalPosition = -1;
    private long inReplyToId = -1L;
    private Integer startLine = -1;
    private Integer originalStartLine = -1;
    private String startSide;
    private int line = -1;
    private int originalLine = -1;
    private String side;
    private String diffHunk;
    private String commitId;
    private String originalCommitId;
    private String bodyHtml;
    private String bodyText;
    private GHPullRequestReviewCommentReactions reactions;
    private GHCommentAuthorAssociation authorAssociation;

    GHPullRequestReviewComment wrapUp(GHPullRequest owner) {
        this.owner = owner;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHPullRequest getParent() {
        return this.owner;
    }

    public String getBody() {
        return this.body;
    }

    public GHUser getUser() throws IOException {
        return this.owner.root().getUser(this.user.getLogin());
    }

    public String getPath() {
        return this.path;
    }

    @CheckForNull
    public int getPosition() {
        return this.position;
    }

    public int getOriginalPosition() {
        return this.originalPosition;
    }

    public String getDiffHunk() {
        return this.diffHunk;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getOriginalCommitId() {
        return this.originalCommitId;
    }

    public GHCommentAuthorAssociation getAuthorAssociation() {
        return this.authorAssociation;
    }

    @CheckForNull
    public long getInReplyToId() {
        return this.inReplyToId;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    protected String getApiRoute() {
        return this.getApiRoute(false);
    }

    protected String getApiRoute(boolean includePullNumber) {
        return "/repos/" + this.owner.getRepository().getFullName() + "/pulls" + (String)(includePullNumber ? "/" + this.owner.getNumber() : "") + "/comments/" + this.getId();
    }

    public int getStartLine() {
        return this.startLine != null ? this.startLine : -1;
    }

    public int getOriginalStartLine() {
        return this.originalStartLine != null ? this.originalStartLine : -1;
    }

    public Side getStartSide() {
        return Side.from(this.startSide);
    }

    public int getLine() {
        return this.line;
    }

    public int getOriginalLine() {
        return this.originalLine;
    }

    public Side getSide() {
        return Side.from(this.side);
    }

    public Long getPullRequestReviewId() {
        return this.pullRequestReviewId != null ? this.pullRequestReviewId : -1L;
    }

    public URL getPullRequestUrl() {
        return GitHubClient.parseURL(this.pullRequestUrl);
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public GHPullRequestReviewCommentReactions getReactions() {
        return this.reactions;
    }

    public void update(String body) throws IOException {
        ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("PATCH")).with("body", body)).withUrlPath(this.getApiRoute(), new String[0])).fetchInto(this);
        this.body = body;
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public GHPullRequestReviewComment reply(String body) throws IOException {
        return ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("body", body)).withUrlPath(this.getApiRoute(true) + "/replies", new String[0])).fetch(GHPullRequestReviewComment.class).wrapUp(this.owner);
    }

    @Override
    public GHReaction createReaction(ReactionContent content) throws IOException {
        return ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("content", content.getContent())).withUrlPath(this.getApiRoute() + "/reactions", new String[0])).fetch(GHReaction.class);
    }

    @Override
    public void deleteReaction(GHReaction reaction) throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), "reactions", String.valueOf(reaction.getId()))).send();
    }

    @Override
    public PagedIterable<GHReaction> listReactions() {
        return ((Requester)this.owner.root().createRequest().withUrlPath(this.getApiRoute() + "/reactions", new String[0])).toIterable(GHReaction[].class, item -> this.owner.root());
    }

    public static enum Side {
        RIGHT,
        LEFT,
        UNKNOWN;


        public static Side from(String value) {
            return EnumUtils.getEnumOrDefault(Side.class, value, UNKNOWN);
        }
    }
}

