/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReleaseUpdater;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHRelease
extends GHObject {
    GHRepository owner;
    private String htmlUrl;
    private String assetsUrl;
    private List<GHAsset> assets;
    private String uploadUrl;
    private String tagName;
    private String targetCommitish;
    private String name;
    private String body;
    private boolean draft;
    private boolean prerelease;
    private String publishedAt;
    private String tarballUrl;
    private String zipballUrl;
    private String discussionUrl;

    public String getDiscussionUrl() {
        return this.discussionUrl;
    }

    public String getAssetsUrl() {
        return this.assetsUrl;
    }

    public String getBody() {
        return this.body;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getOwner() {
        return this.owner;
    }

    public boolean isPrerelease() {
        return this.prerelease;
    }

    @Deprecated
    public Date getPublished_at() {
        return Date.from(this.getPublishedAt());
    }

    public Instant getPublishedAt() {
        return GitHubClient.parseInstant(this.publishedAt);
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTargetCommitish() {
        return this.targetCommitish;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public String getZipballUrl() {
        return this.zipballUrl;
    }

    public String getTarballUrl() {
        return this.tarballUrl;
    }

    GHRelease wrap(GHRepository owner) {
        this.owner = owner;
        return this;
    }

    static GHRelease[] wrap(GHRelease[] releases, GHRepository owner) {
        for (GHRelease release : releases) {
            release.wrap(owner);
        }
        return releases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GHAsset uploadAsset(File file, String contentType) throws IOException {
        try (FileInputStream s = new FileInputStream(file);){
            GHAsset gHAsset = this.uploadAsset(file.getName(), s, contentType);
            return gHAsset;
        }
    }

    public GHAsset uploadAsset(String filename, InputStream stream, String contentType) throws IOException {
        Requester builder = (Requester)this.owner.root().createRequest().method("POST");
        Object url = this.getUploadUrl();
        int endIndex = ((String)url).indexOf(123);
        if (endIndex != -1) {
            url = ((String)url).substring(0, endIndex);
        }
        url = (String)url + "?name=" + URLEncoder.encode(filename, "UTF-8");
        return ((Requester)((Requester)((Requester)builder.contentType(contentType)).with(stream)).withUrlPath((String)url, new String[0])).fetch(GHAsset.class).wrap(this);
    }

    public List<GHAsset> getAssets() {
        return Collections.unmodifiableList(this.assets);
    }

    public PagedIterable<GHAsset> listAssets() {
        Requester builder = this.owner.root().createRequest();
        return ((Requester)builder.withUrlPath(this.getApiTailUrl("assets"), new String[0])).toIterable(GHAsset[].class, item -> item.wrap(this));
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.owner.getApiTailUrl("releases/" + this.getId()), new String[0])).send();
    }

    public GHReleaseUpdater update() {
        return new GHReleaseUpdater(this);
    }

    private String getApiTailUrl(String end) {
        return this.owner.getApiTailUrl(String.format("releases/%s/%s", this.getId(), end));
    }
}

