/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import java.util.Base64;
import org.kohsuke.github.GHBlob;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.Requester;

public class GHBlobBuilder {
    private final GHRepository repo;
    private final Requester req;

    GHBlobBuilder(GHRepository repo) {
        this.repo = repo;
        this.req = repo.root().createRequest();
    }

    public GHBlobBuilder binaryContent(byte[] content) {
        String base64Content = Base64.getEncoder().encodeToString(content);
        this.req.with("content", base64Content);
        this.req.with("encoding", "base64");
        return this;
    }

    public GHBlob create() throws IOException {
        return ((Requester)((Requester)this.req.method("POST")).withUrlPath(this.getApiTail(), new String[0])).fetch(GHBlob.class);
    }

    public GHBlobBuilder textContent(String content) {
        this.req.with("content", content);
        this.req.with("encoding", "utf-8");
        return this;
    }

    private String getApiTail() {
        return String.format("/repos/%s/%s/git/blobs", this.repo.getOwnerName(), this.repo.getName());
    }
}

