/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import org.kohsuke.github.GHContent;
import org.kohsuke.github.GHDirection;
import org.kohsuke.github.GHFork;
import org.kohsuke.github.GHSearchBuilder;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.SearchResult;

public class GHContentSearchBuilder
extends GHSearchBuilder<GHContent> {
    GHContentSearchBuilder(GitHub root) {
        super(root, ContentSearchResult.class);
    }

    public GHContentSearchBuilder extension(String v) {
        return this.q("extension:" + v);
    }

    public GHContentSearchBuilder filename(String v) {
        return this.q("filename:" + v);
    }

    public GHContentSearchBuilder fork(GHFork fork) {
        return this.q("fork", fork.toString());
    }

    public GHContentSearchBuilder in(String v) {
        return this.q("in:" + v);
    }

    public GHContentSearchBuilder language(String v) {
        return this.q("language:" + v);
    }

    public GHContentSearchBuilder order(GHDirection v) {
        this.req.with("order", v);
        return this;
    }

    public GHContentSearchBuilder path(String v) {
        return this.q("path:" + v);
    }

    public GHContentSearchBuilder q(String term) {
        super.q(term);
        return this;
    }

    public GHContentSearchBuilder repo(String v) {
        return this.q("repo:" + v);
    }

    public GHContentSearchBuilder size(String v) {
        return this.q("size:" + v);
    }

    public GHContentSearchBuilder sort(Sort sort) {
        if (Sort.BEST_MATCH.equals((Object)sort)) {
            this.req.remove("sort");
        } else {
            this.req.with("sort", sort);
        }
        return this;
    }

    public GHContentSearchBuilder user(String v) {
        return this.q("user:" + v);
    }

    @Override
    protected String getApiUrl() {
        return "/search/code";
    }

    GHContentSearchBuilder q(String qualifier, String value) {
        super.q(qualifier, value);
        return this;
    }

    private static class ContentSearchResult
    extends SearchResult<GHContent> {
        private GHContent[] items;

        private ContentSearchResult() {
        }

        GHContent[] getItems(GitHub root) {
            return this.items;
        }
    }

    public static enum Sort {
        BEST_MATCH,
        INDEXED;

    }
}

