/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.internal.EnumUtils;

public class GHProjectsV2Item
extends GHObject {
    private String archivedAt;
    private String contentNodeId;
    private String contentType;
    private GHUser creator;
    private String projectNodeId;

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getArchivedAt() {
        return GitHubClient.parseInstant(this.archivedAt);
    }

    public String getContentNodeId() {
        return this.contentNodeId;
    }

    public ContentType getContentType() {
        return EnumUtils.getEnumOrDefault(ContentType.class, this.contentType, ContentType.UNKNOWN);
    }

    public GHUser getCreator() {
        return this.root().intern(this.creator);
    }

    public URL getHtmlUrl() {
        throw new IllegalStateException(this.getClass().getName() + " does not offer a HTML URL.");
    }

    public String getProjectNodeId() {
        return this.projectNodeId;
    }

    public static enum ContentType {
        DRAFTISSUE,
        ISSUE,
        PULLREQUEST,
        UNKNOWN;

    }
}

