/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kohsuke.graph_layouter.Direction;
import org.kohsuke.graph_layouter.Navigator;
import org.kohsuke.graph_layouter.impl.Coordinator;
import org.kohsuke.graph_layouter.impl.EdgeDirection;
import org.kohsuke.graph_layouter.impl.HierarchyBuilder;
import org.kohsuke.graph_layouter.impl.LevelMap;
import org.kohsuke.graph_layouter.impl.OrderAssigner;
import org.kohsuke.graph_layouter.impl.ProperTransformer;
import org.kohsuke.graph_layouter.impl.Vertex;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Layout<T> {
    private final Map<T, Vertex<T>> graph = new LinkedHashMap<T, Vertex<T>>();
    private final Direction dir;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$kohsuke$graph_layouter$Layout;

    public Layout(Navigator<T> nav, Direction dir) {
        this.dir = dir;
        Collection<T> vertices = nav.vertices();
        for (T t : vertices) {
            this.graph.put(t, new Vertex<T>(t, this.rotate(nav.getSize(t))));
        }
        for (T t : vertices) {
            Vertex<T> v = this.graph.get(t);
            for (T u : nav.edge(t)) {
                v.addEdge(this.graph.get(u));
            }
        }
        ArrayList<Vertex<T>> g = new ArrayList<Vertex<T>>(this.graph.values());
        new HierarchyBuilder().assignLevels(g, EdgeDirection.FORWARD);
        new ProperTransformer().makeProper(g);
        LevelMap<T> lm = new OrderAssigner().layout(g);
        new Coordinator().layout(lm);
    }

    public Collection<T> vertices() {
        return this.graph.keySet();
    }

    public Collection<T> edges(T v) {
        ArrayList r = new ArrayList();
        for (Vertex w : this.graph.get(v).forward) {
            if (w.isDummy()) {
                r.add(w.sink.tag);
                continue;
            }
            r.add(w.tag);
        }
        return r;
    }

    public Rectangle vertex(T t) {
        Vertex<T> v = this.graph.get(t);
        if (v == null) {
            return null;
        }
        return this.rotate(v.boundBox());
    }

    public List<Point> edge(T v, T w) {
        Vertex<T> a = this.graph.get(v);
        if (a == null) {
            return null;
        }
        Vertex<T> b = this.graph.get(w);
        if (b == null) {
            return null;
        }
        if (a.forward.contains(b)) {
            return Collections.EMPTY_LIST;
        }
        for (Vertex c : a.forward) {
            if (!$assertionsDisabled && c.source != a) {
                throw new AssertionError();
            }
            if (c.sink != b) continue;
            ArrayList<Point> points = new ArrayList<Point>();
            do {
                points.add(this.rotate(c.pos));
            } while ((c = c.forward.iterator().next()).isDummy());
            return points;
        }
        return null;
    }

    public Rectangle calcDrawingArea() {
        Rectangle area = null;
        for (Vertex<T> v : this.graph.values()) {
            Rectangle vr = v.boundBox();
            if (area == null) {
                area = vr;
                continue;
            }
            area.add(vr);
        }
        if (area == null) {
            area = new Rectangle();
        }
        return this.rotate(area);
    }

    private Dimension rotate(Dimension sz) {
        switch (this.dir) {
            case LEFTRIGHT: {
                return new Dimension(sz.height, sz.width);
            }
            case TOPDOWN: {
                return sz;
            }
        }
        throw new AssertionError();
    }

    private Point rotate(Point p) {
        switch (this.dir) {
            case LEFTRIGHT: {
                return new Point(p.y, p.x);
            }
            case TOPDOWN: {
                return p;
            }
        }
        throw new AssertionError();
    }

    private Rectangle rotate(Rectangle r) {
        switch (this.dir) {
            case LEFTRIGHT: {
                return new Rectangle(r.y, r.x, r.height, r.width);
            }
            case TOPDOWN: {
                return r;
            }
        }
        throw new AssertionError();
    }

    static {
        Class<?> clazz = class$org$kohsuke$graph_layouter$Layout;
        if (clazz == null) {
            clazz = class$org$kohsuke$graph_layouter$Layout = new Layout[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

