/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import net.sf.retrotranslator.runtime.java.lang._Integer;
import org.kohsuke.graph_layouter.impl.Dfs;
import org.kohsuke.graph_layouter.impl.EdgeDirection;
import org.kohsuke.graph_layouter.impl.Level;
import org.kohsuke.graph_layouter.impl.Vertex;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LevelMap<T> {
    private final SortedMap<Integer, Level<T>> core = new TreeMap<Integer, Level<T>>();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$kohsuke$graph_layouter$impl$LevelMap;

    public LevelMap() {
    }

    public LevelMap(Collection<Vertex<T>> graph) {
        new Dfs<T>(EdgeDirection.FORWARD){

            @Override
            protected void in(Vertex<T> v) {
                LevelMap.this.make((int)v.level).vertices.add(v);
            }
        }.run(graph);
        for (Level<T> l : this.levels()) {
            l.assignOrder();
        }
    }

    public Collection<Level<T>> levels() {
        return this.core.values();
    }

    public Level<T> get(int n) {
        return (Level)this.core.get(_Integer.valueOf((int)n));
    }

    public Level<T> make(int n) {
        Level l = (Level)this.core.get(_Integer.valueOf((int)n));
        if (l != null) {
            return l;
        }
        if (this.core.isEmpty()) {
            l = new Level(n);
            this.core.put(_Integer.valueOf((int)l.n), l);
            return l;
        }
        int k = this.core.firstKey();
        if (n < k) {
            l = (Level)this.core.get(_Integer.valueOf((int)k));
            while (l.n != n) {
                l = l.makePrev();
                this.core.put(_Integer.valueOf((int)l.n), l);
            }
            return l;
        }
        k = this.core.lastKey();
        l = (Level)this.core.get(_Integer.valueOf((int)k));
        if (!$assertionsDisabled && k >= n) {
            throw new AssertionError();
        }
        while (l.n != n) {
            l = l.makeNext();
            this.core.put(_Integer.valueOf((int)l.n), l);
        }
        return l;
    }

    public Level<T> first() {
        return (Level)this.core.get(this.core.firstKey());
    }

    public Level<T> last() {
        return (Level)this.core.get(this.core.lastKey());
    }

    public int countCrossing() {
        int crossing = 0;
        for (Level<T> lv : this.levels()) {
            crossing += lv.countCrossings();
        }
        return crossing;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Level<T> lv : this.levels()) {
            buf.append(lv.toString());
            buf.append('\n');
        }
        return buf.toString();
    }

    static {
        Class<?> clazz = class$org$kohsuke$graph_layouter$impl$LevelMap;
        if (clazz == null) {
            clazz = class$org$kohsuke$graph_layouter$impl$LevelMap = new LevelMap[0].getClass().getComponentType();
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public final class Memento {
        private final List<Level.Memento> mementos = new ArrayList<Level.Memento>();

        public Memento() {
            Iterator i$ = LevelMap.this.levels().iterator();
            while (i$.hasNext()) {
                Level lv = i$.next();
                this.mementos.add(lv.new Level.Memento());
            }
        }

        public void restore() {
            Iterator<Level.Memento> i$ = this.mementos.iterator();
            while (i$.hasNext()) {
                Level.Memento m = i$.next();
                m.restore();
            }
        }
    }
}

