/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.util.Set;
import org.kohsuke.graph_layouter.impl.Level;
import org.kohsuke.graph_layouter.impl.LevelDirection;
import org.kohsuke.graph_layouter.impl.Vertex;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface OrderingHeuristic {
    public static final float DONT_MOVE = -1.0f;

    public <T> float weight(Vertex<T> var1, Level<T> var2, LevelDirection var3);

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BaryCenter
    implements OrderingHeuristic {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$org$kohsuke$graph_layouter$impl$OrderingHeuristic;

        @Override
        public <T> float weight(Vertex<T> v, Level<T> current, LevelDirection dir) {
            if (!$assertionsDisabled && !dir.next(current).contains(v)) {
                throw new AssertionError();
            }
            Set<Vertex<T>> fe = dir.backwardEdges(v);
            if (fe.isEmpty()) {
                return -1.0f;
            }
            int r = 0;
            for (Vertex<T> w : fe) {
                r += w.order;
            }
            return (float)r / (float)fe.size();
        }

        static {
            Class<?> clazz = class$org$kohsuke$graph_layouter$impl$OrderingHeuristic;
            if (clazz == null) {
                clazz = class$org$kohsuke$graph_layouter$impl$OrderingHeuristic = new OrderingHeuristic[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeightedMedian
    implements OrderingHeuristic {
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$org$kohsuke$graph_layouter$impl$OrderingHeuristic;

        @Override
        public <T> float weight(Vertex<T> v, Level<T> current, LevelDirection dir) {
            if (!$assertionsDisabled && !dir.next(current).contains(v)) {
                throw new AssertionError();
            }
            Set<Vertex<Vertex>> fe = dir.backwardEdges(v);
            Vertex[] edges = fe.toArray(new Vertex[fe.size()]);
            Vertex.sortByOrder(edges);
            if (edges.length == 0) {
                return -1.0f;
            }
            if (edges.length % 2 == 1) {
                return edges[edges.length / 2].order;
            }
            Vertex medL = edges[edges.length / 2 - 1];
            Vertex medR = edges[edges.length / 2];
            if (edges.length == 2) {
                return ((float)medL.order + (float)medR.order) / 2.0f;
            }
            float left = medL.order - edges[0].order;
            float right = edges[edges.length - 1].order - medR.order;
            return ((float)medL.order * right + (float)medR.order * left) / (left + right);
        }

        static {
            Class<?> clazz = class$org$kohsuke$graph_layouter$impl$OrderingHeuristic;
            if (clazz == null) {
                clazz = class$org$kohsuke$graph_layouter$impl$OrderingHeuristic = new OrderingHeuristic[0].getClass().getComponentType();
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }
    }
}

