/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.graph_layouter.impl.Cluster;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vertex<T> {
    public final Set<Vertex<T>> forward = new HashSet<Vertex<T>>();
    public final Set<Vertex<T>> backward = new HashSet<Vertex<T>>();
    Object dfsMarker;
    int level;
    int order;
    Cluster cluster;
    public final T tag;
    public final Vertex<T> source;
    public final Vertex<T> sink;
    public final Dimension size;
    public final Point pos = new Point();
    private static final Comparator<Vertex> BY_ORDER = new Comparator<Vertex>(){

        @Override
        public int compare(Vertex lhs, Vertex rhs) {
            if (lhs.order < rhs.order) {
                return -1;
            }
            if (lhs.order > rhs.order) {
                return 1;
            }
            return 0;
        }
    };

    public Vertex(T tag, Dimension size) {
        this.tag = tag;
        this.size = size;
        this.sink = null;
        this.source = null;
    }

    Vertex(Vertex<T> source, Vertex<T> sink) {
        this.tag = null;
        this.size = new Dimension(0, 0);
        this.source = source;
        this.sink = sink;
    }

    public void addEdge(Vertex<T> that) {
        this.forward.add(that);
        that.backward.add(this);
    }

    public void addEdges(Vertex<T> ... that) {
        for (Vertex<T> v : that) {
            this.addEdge(v);
        }
    }

    public void removeEdge(Vertex<T> that) {
        this.forward.remove(that);
        that.backward.remove(this);
    }

    public String toString() {
        return this.tag.toString();
    }

    public Point topLeft() {
        return new Point(this.pos.x - this.size.width / 2, this.pos.y - this.size.height / 2);
    }

    public Rectangle boundBox() {
        return new Rectangle(this.topLeft(), this.size);
    }

    public boolean isDummy() {
        return this.source != null;
    }

    public static <T> Vertex<T>[] sortByOrder(Vertex<T>[] array) {
        Arrays.sort(array, BY_ORDER);
        return array;
    }
}

