/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.util.Iterator;
import java.util.Set;
import org.kohsuke.graph_layouter.impl.Level;
import org.kohsuke.graph_layouter.impl.LevelMap;
import org.kohsuke.graph_layouter.impl.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LevelDirection {
    DOWN{

        @Override
        public <T> Level<T> first(LevelMap<T> lm) {
            return lm.first();
        }

        @Override
        public <T> Level<T> next(Level<T> l) {
            return l.next();
        }

        @Override
        public <T> Set<Vertex<T>> forwardEdges(Vertex<T> v) {
            return v.forward;
        }

        @Override
        public <T> Set<Vertex<T>> backwardEdges(Vertex<T> v) {
            return v.backward;
        }

        @Override
        public LevelDirection opposite() {
            return UP;
        }
    }
    ,
    UP{

        @Override
        public <T> Level<T> first(LevelMap<T> lm) {
            return lm.last();
        }

        @Override
        public <T> Level<T> next(Level<T> l) {
            return l.prev();
        }

        @Override
        public <T> Set<Vertex<T>> forwardEdges(Vertex<T> v) {
            return v.backward;
        }

        @Override
        public <T> Set<Vertex<T>> backwardEdges(Vertex<T> v) {
            return v.forward;
        }

        @Override
        public LevelDirection opposite() {
            return DOWN;
        }
    };


    public abstract <T> Level<T> first(LevelMap<T> var1);

    public abstract <T> Level<T> next(Level<T> var1);

    public abstract LevelDirection opposite();

    public abstract <T> Set<Vertex<T>> forwardEdges(Vertex<T> var1);

    public abstract <T> Set<Vertex<T>> backwardEdges(Vertex<T> var1);

    public <T> Iterable<Level<T>> scan(final LevelMap<T> lm) {
        return new Iterable<Level<T>>(){

            @Override
            public Iterator<Level<T>> iterator() {
                return new Iterator<Level<T>>(){
                    Level<T> last;
                    {
                        this.last = LevelDirection.this.first(lm);
                    }

                    @Override
                    public boolean hasNext() {
                        return LevelDirection.this.next(this.last) != null;
                    }

                    @Override
                    public Level<T> next() {
                        this.last = LevelDirection.this.next(this.last);
                        return this.last;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

