/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graph_layouter.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.logging.Logger;
import org.kohsuke.graph_layouter.impl.Level;
import org.kohsuke.graph_layouter.impl.LevelDirection;
import org.kohsuke.graph_layouter.impl.LevelMap;
import org.kohsuke.graph_layouter.impl.OrderingHeuristic;
import org.kohsuke.graph_layouter.impl.Vertex;
import org.kohsuke.graph_layouter.impl.WeightedVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrderAssigner {
    private final OrderingHeuristic orderingHeuristic;
    private static final Logger LOGGER = Logger.getLogger(OrderAssigner.class.getName());
    private static final int MAX_ITERATION = 8;
    private static final Comparator<WeightedVertex<?>> FLIP_EQUALS = new Comparator<WeightedVertex<?>>(){

        @Override
        public int compare(WeightedVertex lhs, WeightedVertex rhs) {
            int r = lhs.compareTo(rhs);
            if (r != 0) {
                return r;
            }
            if (lhs.v.order < rhs.v.order) {
                return 1;
            }
            if (lhs.v.order > rhs.v.order) {
                return -1;
            }
            return 0;
        }
    };

    public OrderAssigner(OrderingHeuristic orderingHeuristic) {
        this.orderingHeuristic = orderingHeuristic;
    }

    public OrderAssigner() {
        this(new OrderingHeuristic.WeightedMedian());
    }

    public <T> LevelMap<T> layout(Collection<Vertex<T>> graph) {
        LevelMap<T> lm = new LevelMap<T>(graph);
        this.layout(lm);
        return lm;
    }

    <T> void layout(LevelMap<T> lm) {
        int xing;
        int newXing;
        for (int i = 0; i < 8; ++i) {
            int xing2 = lm.countCrossing();
            if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                LOGGER.fine("Starting " + i + "th iteration: xing=" + lm.countCrossing());
                LOGGER.fine("Graph=\n" + lm);
            }
            this.reorderAndTranspose(lm);
            if (LOGGER.isLoggable(java.util.logging.Level.FINE)) {
                LOGGER.fine("Finishing " + i + "th iteration: xing=" + lm.countCrossing());
                LOGGER.fine("Graph=\n" + lm);
            }
            if (xing2 != lm.countCrossing()) continue;
            LOGGER.fine("Terminating as we are not making progress");
            return;
        }
        do {
            xing = lm.countCrossing();
            LevelMap.Memento memento = lm.new LevelMap.Memento();
            this.reorderAndTranspose(lm);
            newXing = lm.countCrossing();
            if (newXing <= xing) continue;
            memento.restore();
            return;
        } while (newXing != xing);
    }

    private <T> void reorderAndTranspose(LevelMap<T> lm) {
        LevelDirection dir = LevelDirection.DOWN;
        int j = 0;
        while (j < 4) {
            boolean flipEqual = j < 2;
            this.reorder(dir, lm, flipEqual);
            if (LOGGER.isLoggable(java.util.logging.Level.FINER)) {
                LOGGER.finer("reordered: dir=" + (Object)((Object)dir) + ",xing=" + lm.countCrossing());
                LOGGER.finer("Graph=\n" + lm);
            }
            this.transpose(lm, flipEqual);
            if (LOGGER.isLoggable(java.util.logging.Level.FINER)) {
                LOGGER.finer("transposed: dir=" + (Object)((Object)dir) + ",xing=" + lm.countCrossing());
                LOGGER.finer("Graph=\n" + lm);
            }
            ++j;
            dir = dir.opposite();
        }
    }

    private <T> void reorder(LevelDirection dir, LevelMap<T> lm, boolean flipEqual) {
        Level<T> lv = dir.first(lm);
        while (dir.next(lv) != null) {
            Level<T> nextLevel = dir.next(lv);
            ArrayList orders = new ArrayList(nextLevel.vertices.size());
            for (Vertex v : nextLevel.vertices) {
                assert (v.order == orders.size());
                orders.add(new WeightedVertex(this.orderingHeuristic.weight(v, lv, dir), v));
            }
            BitSet split = new BitSet(orders.size());
            ArrayList<WeightedVertex> dontMoves = new ArrayList<WeightedVertex>();
            int j = 0;
            Iterator itr = orders.iterator();
            while (itr.hasNext()) {
                WeightedVertex o = (WeightedVertex)itr.next();
                split.set(j++, OrderAssigner.isDontMove(o));
                if (!OrderAssigner.isDontMove(o)) continue;
                itr.remove();
                dontMoves.add(o);
            }
            assert (j == nextLevel.vertices.size());
            if (flipEqual) {
                Collections.sort(orders, FLIP_EQUALS);
            } else {
                Collections.sort(orders);
            }
            ArrayList r = new ArrayList(nextLevel.vertices.size());
            itr = dontMoves.iterator();
            Iterator jtr = orders.iterator();
            for (int j2 = 0; j2 < nextLevel.vertices.size(); ++j2) {
                if (split.get(j2)) {
                    r.add(itr.next());
                    continue;
                }
                r.add(jtr.next());
            }
            assert (!itr.hasNext());
            assert (!jtr.hasNext());
            assert (r.size() == nextLevel.vertices.size());
            orders = r;
            nextLevel.reorder(new WeightedVertex.Adapter(orders));
            lv = dir.next(lv);
        }
    }

    private static boolean isDontMove(WeightedVertex v) {
        return v.weight == -1.0f;
    }

    private <T> void transpose(LevelMap<T> lm, boolean flipEqual) {
        boolean improved;
        do {
            improved = false;
            for (Level lv : lm.levels()) {
                int xing = lv.getAdjacentCrossings();
                for (int i = 0; i < lv.vertices.size() - 1; ++i) {
                    Vertex w;
                    Vertex v = lv.vertices.get(i);
                    int swapXing = lv.getAdjacentSwapCrossing(v, w = lv.vertices.get(i + 1));
                    if (swapXing >= xing && (!flipEqual || swapXing != xing)) continue;
                    lv.swap(v, w);
                    improved |= swapXing < xing;
                    xing = swapXing;
                    assert (xing == lv.getAdjacentCrossings());
                }
            }
        } while (improved);
    }
}

