/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graphviz;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.kohsuke.graphviz.Edge;
import org.kohsuke.graphviz.GraphObject;
import org.kohsuke.graphviz.Node;
import org.kohsuke.graphviz.Printer;
import org.kohsuke.graphviz.StreamCopyThread;
import org.kohsuke.graphviz.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Graph
extends GraphObject<Graph> {
    private final List<Node> nodes = new ArrayList<Node>();
    private final List<Edge> edges = new ArrayList<Edge>();
    private final List<Graph> subGraphs = new ArrayList<Graph>();
    private Style nodeWith;
    private Style edgeWith;
    private boolean to;

    public Graph nodeWith(Style s) {
        this.nodeWith = s;
        return this;
    }

    public Graph edgeWith(Style s) {
        this.edgeWith = s;
        return this;
    }

    private <T extends GraphObject> T decorate(T t, Style with) {
        if (with != null && t.style() == null) {
            t.style(with);
        }
        return t;
    }

    public Graph node(Node n) {
        this.nodes.add(this.decorate(n, this.nodeWith));
        if (this.to) {
            this.to = false;
            int sz = this.nodes.size();
            this.edge(this.nodes.get(sz - 2), this.nodes.get(sz - 1));
        }
        return this;
    }

    public Graph node(String label) {
        return this.node(label, null);
    }

    public Graph node(String label, Style s) {
        return this.node((Node)((Node)new Node().attr("label", label)).style(s));
    }

    public Graph to() {
        this.to = true;
        return this;
    }

    public Graph edge(Edge e) {
        this.edges.add(this.decorate(e, this.edgeWith));
        return this;
    }

    public Graph edge(Node src, Node dst) {
        return this.edge(src, dst, null);
    }

    public Graph edge(Node src, Node dst, Style s) {
        return this.edge((Edge)new Edge(src, dst).style(s));
    }

    public Graph subGraph(Graph g) {
        this.subGraphs.add(g);
        return this;
    }

    @Override
    Graph self() {
        return this;
    }

    public void writeTo(OutputStream out) {
        this.writeTo(new Printer(out));
    }

    private void writeTo(Printer out) {
        out.println("digraph " + out.id(this) + " {");
        this.writeNodes(out);
        this.writeEdges(out);
        out.println("}");
    }

    private void writeNodes(Printer out) {
        Map<String, String> m = this.getEffectiveAttributes();
        for (Map.Entry<String, String> e : m.entrySet()) {
            out.print(e.getKey());
            out.print('=');
            out.println(Graph.escape(e.getValue()));
        }
        for (Node n : this.nodes) {
            n.write(out);
        }
        for (Graph g : this.subGraphs) {
            out.println("subgraph " + out.id(this) + " {");
            g.writeNodes(out);
            out.println("}");
        }
    }

    private void writeEdges(Printer out) {
        for (Edge e : this.edges) {
            e.write(out);
        }
        for (Graph g : this.subGraphs) {
            g.writeEdges(out);
        }
    }

    public void generateTo(List<String> commands, OutputStream out) throws InterruptedException, IOException {
        ProcessBuilder pb = new ProcessBuilder(commands);
        Process proc = pb.start();
        ByteArrayOutputStream error = new ByteArrayOutputStream();
        StreamCopyThread t1 = new StreamCopyThread("stderr for " + Arrays.asList(commands), proc.getErrorStream(), error);
        StreamCopyThread t2 = new StreamCopyThread("stdout for " + Arrays.asList(commands), proc.getInputStream(), out);
        t1.start();
        t2.start();
        this.writeTo(proc.getOutputStream());
        proc.getOutputStream().close();
        int r = proc.waitFor();
        t1.join();
        t2.join();
        if (r != 0) {
            throw new IllegalArgumentException(error.toString());
        }
    }

    public void generateTo(List<String> commands, File f) throws InterruptedException, IOException {
        commands = new ArrayList<String>(commands);
        commands.add("-o");
        commands.add(f.getAbsolutePath());
        this.generateTo(commands, new ByteArrayOutputStream());
    }
}

