/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.graphviz;

import java.util.LinkedHashMap;
import java.util.Map;
import org.kohsuke.graphviz.Attribute;
import org.kohsuke.graphviz.Printer;
import org.kohsuke.graphviz.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphObject<T extends GraphObject<T>> {
    private Style style;
    private final LinkedHashMap<String, String> attributes = new LinkedHashMap();
    String id;

    public final T id(String id) {
        this.id = id;
        return this.self();
    }

    public final T style(Style s) {
        this.style = s;
        return this.self();
    }

    public Style style() {
        return this.style;
    }

    public final T attr(String name, String value) {
        this.attributes.put(name, value);
        return this.self();
    }

    public final <V> T attr(Attribute<V> attribute, V value) {
        return this.attr(attribute.name, attribute.toString(value));
    }

    public final String attr(String name) {
        String v;
        if (this.style != null && (v = this.style.attr(name)) != null) {
            return v;
        }
        return this.attributes.get(name);
    }

    public final <V> V attr(Attribute<V> attribute) {
        return attribute.fromString(this.attr(attribute.name));
    }

    abstract T self();

    public Map<String, String> getEffectiveAttributes() {
        if (this.style == null) {
            return new LinkedHashMap<String, String>(this.attributes);
        }
        Map<String, String> r = this.style.getEffectiveAttributes();
        r.putAll(this.attributes);
        return r;
    }

    final void writeAttributes(Printer w) {
        Map<String, String> m = this.getEffectiveAttributes();
        if (!m.isEmpty()) {
            w.print('[');
            boolean hasHtmlLabel = m.containsKey("html");
            boolean first = true;
            for (Map.Entry<String, String> e : m.entrySet()) {
                if (hasHtmlLabel && e.getKey().equals("label")) continue;
                if (!first) {
                    w.print(',');
                } else {
                    first = false;
                }
                if (hasHtmlLabel && e.getKey().equals("html")) {
                    w.print("label=<");
                    w.print(e.getValue());
                    w.print('>');
                    continue;
                }
                w.print(e.getKey());
                w.print('=');
                w.print(GraphObject.escape(e.getValue()));
            }
            w.print(']');
        }
    }

    protected static String escape(String value) {
        StringBuilder buf = new StringBuilder("\"");
        block4: for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(i);
            switch (ch) {
                case '\"': {
                    buf.append("\\\"");
                    continue block4;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block4;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }
}

