/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.groovy.sandbox;

import org.kohsuke.groovy.sandbox.GroovyInterceptor;

public class ClassRecorder
extends GroovyInterceptor {
    private final StringBuilder buf = new StringBuilder();

    public String toString() {
        return this.buf.toString();
    }

    public void reset() {
        this.buf.setLength(0);
    }

    private void format(String fmt, Object ... args) {
        this.buf.append(String.format(fmt, args)).append('\n');
    }

    private String type(Object o) {
        return o == null ? "null" : this.type(o.getClass());
    }

    private String type(Class c) {
        if (c.isArray()) {
            return this.type(c.getComponentType()) + "[]";
        }
        String n = c.getName();
        return n.substring(n.lastIndexOf(46) + 1);
    }

    private String arguments(Object ... args) {
        StringBuilder b = new StringBuilder();
        for (Object o : args) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(this.type(o));
        }
        return b.toString();
    }

    public Object onMethodCall(GroovyInterceptor.Invoker invoker, Object receiver, String method, Object ... args) throws Throwable {
        this.format("%s.%s(%s)", this.type(receiver), method, this.arguments(args));
        return super.onMethodCall(invoker, receiver, method, args);
    }

    public Object onStaticCall(GroovyInterceptor.Invoker invoker, Class receiver, String method, Object ... args) throws Throwable {
        this.format("%s:%s(%s)", this.type(receiver), method, this.arguments(args));
        return super.onStaticCall(invoker, receiver, method, args);
    }

    public Object onNewInstance(GroovyInterceptor.Invoker invoker, Class receiver, Object ... args) throws Throwable {
        this.format("new %s(%s)", this.type(receiver), this.arguments(args));
        return super.onNewInstance(invoker, receiver, args);
    }

    public Object onGetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property) throws Throwable {
        this.format("%s.%s", this.type(receiver), property);
        return super.onGetProperty(invoker, receiver, property);
    }

    public Object onSetProperty(GroovyInterceptor.Invoker invoker, Object receiver, String property, Object value) throws Throwable {
        this.format("%s.%s=%s", this.type(receiver), property, this.type(value));
        return super.onSetProperty(invoker, receiver, property, value);
    }

    public Object onGetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute) throws Throwable {
        this.format("%s.@%s", this.type(receiver), attribute);
        return super.onGetAttribute(invoker, receiver, attribute);
    }

    public Object onSetAttribute(GroovyInterceptor.Invoker invoker, Object receiver, String attribute, Object value) throws Throwable {
        this.format("%s.@%s=%s", this.type(receiver), attribute, this.type(value));
        return super.onSetAttribute(invoker, receiver, attribute, value);
    }

    public Object onGetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index) throws Throwable {
        this.format("%s[%s]", this.type(receiver), this.type(index));
        return super.onGetArray(invoker, receiver, index);
    }

    public Object onSetArray(GroovyInterceptor.Invoker invoker, Object receiver, Object index, Object value) throws Throwable {
        this.format("%s[%s]=%s", this.type(receiver), this.type(index), this.type(value));
        return super.onSetArray(invoker, receiver, index, value);
    }
}

