/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.kohsuke.CaptureJavadoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedAnnotationTypes(value={"org.kohsuke.CaptureJavadoc"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CaptureJavadocProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getElementsAnnotatedWith(CaptureJavadoc.class)) {
            String fqcn = ((TypeElement)element).getQualifiedName().toString();
            String doc = this.processingEnv.getElementUtils().getDocComment(element);
            if (doc == null || doc.trim().length() <= 0) continue;
            String fileName = fqcn.replace('.', '/') + ".javadoc";
            try {
                FileObject f = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", fileName, new Element[0]);
                OutputStreamWriter w = new OutputStreamWriter(f.openOutputStream(), "UTF-8");
                w.write(doc);
                ((Writer)w).close();
            }
            catch (IOException x) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate " + fileName, element);
                x.printStackTrace();
            }
        }
        return true;
    }
}

