/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.mortbay.jetty.plugin.AbstractJetty6Mojo;
import org.mortbay.util.Scanner;

public class Jetty6RunWarExploded
extends AbstractJetty6Mojo {
    private File webApp;

    public void checkPomConfiguration() throws MojoExecutionException {
    }

    public void configureScanner() throws MojoExecutionException {
        File jettyEnvXmlFile;
        ArrayList<File> scanList = new ArrayList<File>();
        scanList.add(this.getProject().getFile());
        File webInfDir = new File(this.webApp, "WEB-INF");
        scanList.add(new File(webInfDir, "web.xml"));
        File jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir);
        if (jettyWebXmlFile != null) {
            scanList.add(jettyWebXmlFile);
        }
        if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
            scanList.add(jettyEnvXmlFile);
        }
        scanList.add(new File(webInfDir, "classes"));
        scanList.add(new File(webInfDir, "lib"));
        this.setScanList(scanList);
        ArrayList<1> listeners = new ArrayList<1>();
        listeners.add(new Scanner.BulkListener(){

            public void filesChanged(List changes) {
                try {
                    boolean reconfigure = changes.contains(Jetty6RunWarExploded.this.getProject().getFile().getCanonicalPath());
                    Jetty6RunWarExploded.this.restartWebApp(reconfigure);
                }
                catch (Exception e) {
                    Jetty6RunWarExploded.this.getLog().error((CharSequence)"Error reconfiguring/restarting webapp after change in watched files", (Throwable)e);
                }
            }
        });
        this.setScannerListeners(listeners);
    }

    public void restartWebApp(boolean reconfigureScanner) throws Exception {
        this.getLog().info((CharSequence)"Restarting webapp");
        this.getLog().debug((CharSequence)"Stopping webapp ...");
        this.webAppConfig.stop();
        this.getLog().debug((CharSequence)"Reconfiguring webapp ...");
        this.checkPomConfiguration();
        if (reconfigureScanner) {
            File jettyEnvXmlFile;
            this.getLog().info((CharSequence)"Reconfiguring scanner after change to pom.xml ...");
            ArrayList scanList = this.getScanList();
            scanList.clear();
            scanList.add(this.getProject().getFile());
            File webInfDir = new File(this.webApp, "WEB-INF");
            scanList.add(new File(webInfDir, "web.xml"));
            File jettyWebXmlFile = this.findJettyWebXmlFile(webInfDir);
            if (jettyWebXmlFile != null) {
                scanList.add(jettyWebXmlFile);
            }
            if ((jettyEnvXmlFile = new File(webInfDir, "jetty-env.xml")).exists()) {
                scanList.add(jettyEnvXmlFile);
            }
            scanList.add(new File(webInfDir, "classes"));
            scanList.add(new File(webInfDir, "lib"));
            this.setScanList(scanList);
            this.getScanner().setScanDirs((List)scanList);
        }
        this.getLog().debug((CharSequence)"Restarting webapp ...");
        this.webAppConfig.start();
        this.getLog().info((CharSequence)"Restart completed.");
    }

    public void finishConfigurationBeforeStart() throws Exception {
    }

    public void configureWebApplication() throws Exception {
        super.configureWebApplication();
        this.webAppConfig.setWar(this.webApp.getCanonicalPath());
        this.webAppConfig.configure();
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }
}

