/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.jinterop;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Iterator;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.jinterop.dcom.impls.automation.IJIEnumVariant;
import org.jvnet.tiger_types.Types;
import org.kohsuke.jinterop.JIProxy;
import org.kohsuke.jinterop.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JInteropInvocationHandler
implements InvocationHandler {
    private final IJIDispatch core;
    private final Class<? extends JIProxy> interfaceType;
    private final Class staticImplementation;

    public static <T extends JIProxy> T wrap(Class<T> type, IJIDispatch obj) {
        return (T)((JIProxy)type.cast(Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new JInteropInvocationHandler(obj, type))));
    }

    public static <T extends JIProxy> T wrap(Class<T> type, IJIComObject obj) throws JIException {
        return JInteropInvocationHandler.wrap(type, (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)obj.queryInterface("00020400-0000-0000-c000-000000000046")));
    }

    public JInteropInvocationHandler(IJIDispatch core, Class<? extends JIProxy> interfaceType) {
        this.core = core;
        this.interfaceType = interfaceType;
        this.staticImplementation = this.findStaticImplementation();
    }

    private Class findStaticImplementation() {
        try {
            return this.interfaceType.getClassLoader().loadClass(this.interfaceType.getName() + "$Implementation");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == IJIDispatch.class) {
            return method.invoke((Object)this.core, args);
        }
        if (method.getDeclaringClass() == JIProxy.class) {
            return JInteropInvocationHandler.wrap((Class)args[0], this.core);
        }
        if (method.getDeclaringClass() == Iterable.class) {
            IJIComObject object2 = this.core.get("_NewEnum").getObjectAsComObject();
            final IJIEnumVariant enumVARIANT = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)object2.queryInterface("00020404-0000-0000-C000-000000000046"));
            final Class expectedType = Types.erasure((Type)Types.getTypeArgument((Type)Types.getBaseClass(this.interfaceType, Iterable.class), (int)0));
            return new Iterator(){
                Object next;
                boolean end = false;

                public boolean hasNext() {
                    this.fetch();
                    return this.next != null;
                }

                public Object next() {
                    this.fetch();
                    Object r = this.next;
                    this.next = null;
                    return r;
                }

                private void fetch() {
                    try {
                        if (this.next != null || this.end) {
                            return;
                        }
                        Object[] values = enumVARIANT.next(1);
                        if (values.length == 0) {
                            return;
                        }
                        if (values.length != 2) {
                            throw new AssertionError((Object)("Returned " + values.length));
                        }
                        Object[] ai = (Object[])((JIArray)values[0]).getArrayInstance();
                        if (ai.length != 1) {
                            throw new AssertionError(ai);
                        }
                        this.next = JInteropInvocationHandler.this.unmarshal((JIVariant)ai[0], expectedType);
                    }
                    catch (JIException e) {
                        if (e.getErrorCode() == 1) {
                            this.end = true;
                            return;
                        }
                        throw new RuntimeException(e);
                    }
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (method.getAnnotation(Property.class) != null) {
            return this.unmarshal(this.core.get(method.getName()), method.getReturnType());
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        if (this.staticImplementation != null) {
            Class[] staticParams = new Class[paramTypes.length + 1];
            System.arraycopy(paramTypes, 0, staticParams, 1, paramTypes.length);
            staticParams[0] = this.interfaceType;
            try {
                Method stm = this.staticImplementation.getMethod(method.getName(), staticParams);
                Object[] staticArgs = new Object[staticParams.length];
                if (args != null) {
                    System.arraycopy(args, 0, staticArgs, 1, args.length);
                }
                staticArgs[0] = proxy;
                return stm.invoke(null, staticArgs);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            args[i] = this.marshal(args[i], paramTypes[i]);
        }
        JIVariant[] r = this.core.callMethodA(method.getName(), args);
        return this.unmarshal(r[0], method.getReturnType());
    }

    private Object marshal(Object v, Class<?> declaredType) throws JIException {
        if (v == null) {
            return JIVariant.OPTIONAL_PARAM();
        }
        Class<?> actualType = v.getClass();
        if (actualType == String.class) {
            return new JIString((String)v);
        }
        return v;
    }

    private Object unmarshal(JIVariant v, Class<?> returnType) throws JIException {
        if (returnType == IJIDispatch.class) {
            return JIObjectFactory.narrowObject((IJIComObject)v.getObjectAsComObject());
        }
        if (JIProxy.class.isAssignableFrom(returnType)) {
            return JInteropInvocationHandler.wrap(returnType.asSubclass(JIProxy.class), v.getObjectAsComObject());
        }
        if (returnType == JIVariant.class) {
            return v;
        }
        if (returnType == Integer.TYPE || returnType == Integer.class) {
            return v.getObjectAsInt();
        }
        if (returnType == Void.TYPE) {
            return null;
        }
        if (returnType == String.class) {
            return v.getObjectAsString2();
        }
        if (returnType == Boolean.TYPE) {
            return v.getObjectAsBoolean();
        }
        throw new UnsupportedOperationException(returnType.getName());
    }
}

