/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.solaris.libzfs;

import java.io.File;
import org.jvnet.solaris.libzfs.LibZFS;
import org.jvnet.solaris.libzfs.ZFSException;
import org.jvnet.solaris.libzfs.ZFSObject;
import org.jvnet.solaris.libzfs.jna.libzfs;
import org.jvnet.solaris.libzfs.jna.zfs_handle_t;
import org.jvnet.solaris.libzfs.jna.zfs_prop_t;

public final class ZFSFileSystem
extends ZFSObject {
    ZFSFileSystem(LibZFS parent, zfs_handle_t handle) {
        super(parent, handle);
    }

    public boolean isMounted() {
        boolean isMounted = libzfs.LIBZFS.zfs_is_mounted(this.handle, null);
        return isMounted;
    }

    public File getMountPoint() {
        String mp = this.getZfsProperty(zfs_prop_t.ZFS_PROP_MOUNTPOINT);
        if (mp == null || mp.equals("legacy") || mp.equals("none")) {
            return null;
        }
        return new File(mp);
    }

    public void setMountPoint(File loc) {
        this.setProperty("mountpoint", loc.getAbsolutePath());
    }

    public void mount() {
        this.mount(0);
    }

    public void mount(int flags) {
        int r = libzfs.LIBZFS.zfs_mount(this.handle, null, flags);
        if (r != 0) {
            throw new ZFSException(this.library, "Failed to mount " + this.getName() + ": code=" + r);
        }
    }

    public void unmount() {
        this.unmount(0);
    }

    public void unmount(int flags) {
        if (libzfs.LIBZFS.zfs_unmount(this.handle, null, flags) != 0) {
            throw new ZFSException(this.library, "Failed to unmount " + this.getName());
        }
    }

    public void share() {
        if (libzfs.LIBZFS.zfs_share(this.handle) != 0) {
            throw new ZFSException(this.library);
        }
    }

    public void unshare() {
        if (libzfs.LIBZFS.zfs_unshare(this.handle) != 0) {
            throw new ZFSException(this.library);
        }
    }
}

