/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.solaris.libzfs;

import com.sun.jna.Memory;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jvnet.solaris.libzfs.LibZFS;
import org.jvnet.solaris.libzfs.ZFSContainer;
import org.jvnet.solaris.libzfs.ZFSException;
import org.jvnet.solaris.libzfs.ZFSFileSystem;
import org.jvnet.solaris.libzfs.ZFSPool;
import org.jvnet.solaris.libzfs.ZFSSnapshot;
import org.jvnet.solaris.libzfs.ZFSType;
import org.jvnet.solaris.libzfs.ZFSVolume;
import org.jvnet.solaris.libzfs.jna.libzfs;
import org.jvnet.solaris.libzfs.jna.zfs_handle_t;
import org.jvnet.solaris.libzfs.jna.zfs_prop_t;
import org.jvnet.solaris.nvlist.jna.nvlist_t;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ZFSObject
implements Comparable<ZFSObject>,
ZFSContainer {
    final LibZFS library;
    zfs_handle_t handle;
    private final String name;

    ZFSObject(LibZFS library, zfs_handle_t handle) {
        this.library = library;
        if (handle == null) {
            throw new ZFSException(library);
        }
        this.handle = handle;
        this.name = libzfs.LIBZFS.zfs_get_name(this.handle);
    }

    static ZFSObject create(LibZFS parent, zfs_handle_t handle) {
        switch (ZFSType.fromCode(libzfs.LIBZFS.zfs_get_type(handle))) {
            case FILESYSTEM: {
                return new ZFSFileSystem(parent, handle);
            }
            case SNAPSHOT: {
                return new ZFSSnapshot(parent, handle);
            }
            case VOLUME: {
                return new ZFSVolume(parent, handle);
            }
        }
        throw new AssertionError();
    }

    public LibZFS getLibrary() {
        return this.library;
    }

    public ZFSPool getPool() {
        int idx = this.name.indexOf(47);
        if (idx < 0) {
            return this.library.getPool(this.name);
        }
        return this.library.getPool(this.name.substring(0, idx));
    }

    @Override
    public int compareTo(ZFSObject that) {
        long b;
        long a = Long.parseLong(this.getZfsProperty(zfs_prop_t.ZFS_PROP_CREATETXG));
        if (a > (b = Long.parseLong(that.getZfsProperty(zfs_prop_t.ZFS_PROP_CREATETXG)))) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        return 0;
    }

    public List<ZFSObject> children() {
        return this.children(ZFSObject.class);
    }

    @Override
    public <T extends ZFSObject> List<T> children(Class<T> type) {
        return this.children(type, new ArrayList(), false);
    }

    @Override
    public List<ZFSObject> descendants() {
        return this.children(ZFSObject.class);
    }

    @Override
    public <T extends ZFSObject> List<T> descendants(Class<T> type) {
        return this.children(type, new ArrayList(), true);
    }

    private <T extends ZFSObject> List<T> children(Class<T> type, List<T> list, boolean recursive) {
        for (ZFSObject zFSObject : this.snapshots()) {
            if (!type.isInstance(zFSObject)) continue;
            list.add(type.cast(zFSObject));
        }
        for (ZFSObject zFSObject : this.getChildren()) {
            if (zFSObject.getName().contains("@")) continue;
            if (type.isInstance(zFSObject)) {
                list.add(type.cast(zFSObject));
            }
            if (!recursive) continue;
            zFSObject.children(type, list, recursive);
        }
        return list;
    }

    public ZFSFileSystem clone(String fullDestinationName) {
        if (libzfs.LIBZFS.zfs_clone(this.handle, fullDestinationName, null) != 0) {
            throw new ZFSException(this.library);
        }
        ZFSFileSystem target = (ZFSFileSystem)this.library.open(fullDestinationName);
        target.mount();
        target.share();
        return target;
    }

    public ZFSFileSystem createFileSystem(String name, Map<String, String> props) {
        return (ZFSFileSystem)this.library.create(this.getName() + '/' + name, ZFSType.FILESYSTEM, props);
    }

    public ZFSFileSystem openFileSystem(String name) {
        return this.library.open(this.getName() + '/' + name, ZFSFileSystem.class);
    }

    public ZFSSnapshot createSnapshot(String snapshotName) {
        ZFSSnapshot dataSet = this.createSnapshot(snapshotName, false);
        return dataSet;
    }

    public ZFSSnapshot createSnapshot(String snapshotName, boolean recursive) {
        String fullName = this.name + '@' + snapshotName;
        if (libzfs.LIBZFS.zfs_snapshot(this.library.getHandle(), fullName, recursive, null) != 0) {
            throw new ZFSException(this.library);
        }
        ZFSSnapshot dataSet = (ZFSSnapshot)this.library.open(fullName, 2);
        return dataSet;
    }

    public void destory() {
        this.destroy();
    }

    public void destory(boolean recursive) {
        this.destroy(recursive);
    }

    public void destroy() {
        if (libzfs.LIBZFS.zfs_destroy(this.handle, false) != 0) {
            throw new ZFSException(this.library, "Failed to destroy " + this.getName());
        }
    }

    public void destroy(boolean recursive) {
        if (recursive) {
            for (ZFSObject child : this.children()) {
                child.destroy(recursive);
            }
        }
        this.destroy();
    }

    public synchronized void dispose() {
        if (this.handle != null) {
            libzfs.LIBZFS.zfs_close(this.handle);
        }
        this.handle = null;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZFSObject zfsObject = (ZFSObject)o;
        boolean equals = this.handle.equals((Object)zfsObject.handle);
        return equals;
    }

    public List<ZFSObject> filesystems() {
        final ArrayList<ZFSObject> r = new ArrayList<ZFSObject>();
        libzfs.LIBZFS.zfs_iter_filesystems(this.handle, new libzfs.zfs_iter_f(){

            public int callback(zfs_handle_t handle, Pointer arg) {
                r.add(ZFSObject.create(ZFSObject.this.library, handle));
                return 0;
            }
        }, null);
        return r;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public List<ZFSObject> getChildren() {
        final ArrayList<ZFSObject> list = new ArrayList<ZFSObject>();
        libzfs.LIBZFS.zfs_iter_children(this.handle, new libzfs.zfs_iter_f(){

            public int callback(zfs_handle_t handle, Pointer arg) {
                list.add(ZFSObject.create(ZFSObject.this.library, handle));
                return 0;
            }
        }, null);
        return list;
    }

    public String getName() {
        return this.name;
    }

    public ZFSType getType() {
        return ZFSType.fromCode(libzfs.LIBZFS.zfs_get_type(this.handle));
    }

    public Map<zfs_prop_t, String> getZfsProperty(Collection<zfs_prop_t> props) {
        Memory propbuf = new Memory(1024L);
        char[] buf = null;
        IntByReference ibr = null;
        Hashtable<zfs_prop_t, String> map = new Hashtable<zfs_prop_t, String>();
        for (zfs_prop_t prop : props) {
            int ret = libzfs.LIBZFS.zfs_prop_get(this.handle, new NativeLong((long)prop.ordinal()), (Pointer)propbuf, 1024, ibr, buf, new NativeLong(0L), true);
            if (ret != 0) continue;
            map.put(prop, propbuf.getString(0L));
        }
        return map;
    }

    public String getZfsProperty(zfs_prop_t prop) {
        Memory propbuf = new Memory(1024L);
        char[] buf = null;
        IntByReference ibr = null;
        int ret = libzfs.LIBZFS.zfs_prop_get(this.handle, new NativeLong((long)prop.ordinal()), (Pointer)propbuf, 1024, ibr, buf, new NativeLong(0L), true);
        return ret != 0 ? null : propbuf.getString(0L);
    }

    public Hashtable<String, String> getUserProperty(Collection<String> keys) {
        Hashtable<String, String> map = new Hashtable<String, String>();
        nvlist_t userProps = libzfs.LIBZFS.zfs_get_user_props(this.handle);
        for (String key : keys) {
            nvlist_t v = userProps.getNVList(key);
            if (v == null) {
                return null;
            }
            map.put(key, v.getString("value"));
        }
        return map;
    }

    public String getUserProperty(String key) {
        nvlist_t userProps = libzfs.LIBZFS.zfs_get_user_props(this.handle);
        nvlist_t v = userProps.getNVList(key);
        if (v == null) {
            return null;
        }
        return v.getString("value");
    }

    public final int hashCode() {
        return this.handle.hashCode();
    }

    public void inheritProperty(String key) {
        if (libzfs.LIBZFS.zfs_prop_inherit(this.handle, key) != 0) {
            throw new ZFSException(this.library);
        }
        this.dispose();
        this.handle = libzfs.LIBZFS.zfs_open(this.library.getHandle(), this.name, 7);
    }

    public boolean isShared() {
        boolean isShared = libzfs.LIBZFS.zfs_is_shared(this.handle);
        return isShared;
    }

    public ZFSObject rename(String fullName, boolean recursive) {
        if (libzfs.LIBZFS.zfs_rename(this.handle, fullName, recursive) != 0) {
            throw new ZFSException(this.library);
        }
        return this.library.open(fullName);
    }

    public ZFSObject rollback(boolean recursive) {
        String filesystem = this.name.substring(0, this.getName().indexOf("@"));
        ZFSObject fs = this.library.open(filesystem);
        if (recursive) {
            List<ZFSObject> list = fs.getChildren();
            for (ZFSObject child : list) {
                if (child.getName().startsWith(filesystem + "@")) continue;
                return child;
            }
            boolean found = false;
            for (ZFSObject zFSObject : fs.snapshots()) {
                String name = zFSObject.getName();
                if (name.equals(this.getName())) {
                    found = true;
                    continue;
                }
                if (!found) continue;
                zFSObject.destory();
            }
        }
        if (libzfs.LIBZFS.zfs_rollback(fs.handle, this.handle, recursive) != 0) {
            throw new ZFSException(this.library);
        }
        return this.library.open(filesystem);
    }

    public void setProperty(String key, String value) {
        if (libzfs.LIBZFS.zfs_prop_set(this.handle, key, value) != 0) {
            throw new ZFSException(this.library, "Failed to set property " + key + " on " + this.getName());
        }
    }

    public Set<ZFSSnapshot> snapshots() {
        final TreeSet<ZFSSnapshot> set = new TreeSet<ZFSSnapshot>();
        String abi = this.library.getFeature("LIBZFS4J_ABI_zfs_iter_snapshots");
        if (abi.equals("openzfs")) {
            libzfs.LIBZFS.zfs_iter_snapshots(this.handle, false, new libzfs.zfs_iter_f(){

                public int callback(zfs_handle_t handle, Pointer arg) {
                    set.add((ZFSSnapshot)ZFSObject.create(ZFSObject.this.library, handle));
                    return 0;
                }
            }, null);
        } else {
            libzfs.LIBZFS.zfs_iter_snapshots(this.handle, new libzfs.zfs_iter_f(){

                public int callback(zfs_handle_t handle, Pointer arg) {
                    set.add((ZFSSnapshot)ZFSObject.create(ZFSObject.this.library, handle));
                    return 0;
                }
            }, null);
        }
        return set;
    }

    public String toString() {
        return this.getName();
    }
}

