/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.solaris.nvlist.jna;

import com.sun.jna.PointerType;
import com.sun.jna.ptr.PointerByReference;
import org.jvnet.solaris.jna.PtrByReference;
import org.jvnet.solaris.nvlist.jna.NVListException;
import org.jvnet.solaris.nvlist.jna.libnvpair;

public class nvlist_t
extends PointerType {
    private boolean owner;

    public static nvlist_t alloc(int nvflag) {
        PtrByReference<nvlist_t> buf = new PtrByReference<nvlist_t>();
        if (libnvpair.LIBNVPAIR.nvlist_alloc(buf, nvflag, 0) != 0) {
            throw new NVListException();
        }
        nvlist_t r = buf.getValue(nvlist_t.class);
        r.owner = true;
        return r;
    }

    public static nvlist_t allocMap() {
        return nvlist_t.alloc(1);
    }

    public void put(String key, String value) {
        if (libnvpair.LIBNVPAIR.nvlist_add_string(this, key, value) != 0) {
            throw new NVListException();
        }
    }

    public void put(String key, boolean value) {
        if (value ? libnvpair.LIBNVPAIR.nvlist_add_boolean(this, key) != 0 : libnvpair.LIBNVPAIR.nvlist_add_boolean_value(this, key, value) != 0) {
            throw new NVListException();
        }
    }

    public void put(String key, nvlist_t value) {
        if (libnvpair.LIBNVPAIR.nvlist_add_nvlist(this, key, value) != 0) {
            throw new NVListException();
        }
    }

    public String getString(String key) {
        PointerByReference r = new PointerByReference();
        if (libnvpair.LIBNVPAIR.nvlist_lookup_string(this, key, r) != 0) {
            return null;
        }
        return r.getValue().getString(0L);
    }

    public nvlist_t getNVList(String key) {
        PtrByReference<nvlist_t> r = new PtrByReference<nvlist_t>();
        if (libnvpair.LIBNVPAIR.nvlist_lookup_nvlist(this, key, r) != 0) {
            return null;
        }
        return r.getValue(nvlist_t.class);
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    private synchronized void dispose() {
        if (this.owner) {
            libnvpair.LIBNVPAIR.nvlist_free(this);
        }
        this.owner = false;
    }
}

