package com.sun.maven.junit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

/**
 * Display help information on maven-junit-plugin.<br/> Call <pre>  mvn junit:help -Ddetail=true -Dgoal=&lt;goal-name&gt;</pre> to display parameter details.
 *
 * @version generated on Thu Jan 03 13:32:49 PST 2013
 * @author org.apache.maven.tools.plugin.generator.PluginHelpGenerator (version 2.7)
 * @goal help
 * @requiresProject false
 * @threadSafe
 */
public class HelpMojo
    extends AbstractMojo
{
    /**
     * If <code>true</code>, display all settable properties for each goal.
     * 
     * @parameter expression="${detail}" default-value="false"
     */
    private boolean detail;

    /**
     * The name of the goal for which to show help. If unspecified, all goals will be displayed.
     * 
     * @parameter expression="${goal}"
     */
    private java.lang.String goal;

    /**
     * The maximum length of a display line, should be positive.
     * 
     * @parameter expression="${lineLength}" default-value="80"
     */
    private int lineLength;

    /**
     * The number of spaces per indentation level, should be positive.
     * 
     * @parameter expression="${indentSize}" default-value="2"
     */
    private int indentSize;


    /** {@inheritDoc} */
    public void execute()
        throws MojoExecutionException
    {
        if ( lineLength <= 0 )
        {
            getLog().warn( "The parameter 'lineLength' should be positive, using '80' as default." );
            lineLength = 80;
        }
        if ( indentSize <= 0 )
        {
            getLog().warn( "The parameter 'indentSize' should be positive, using '2' as default." );
            indentSize = 2;
        }

        StringBuffer sb = new StringBuffer();

        append( sb, "org.kohsuke:maven-junit-plugin:1.11", 0 );
        append( sb, "", 0 );

        append( sb, "maven-junit-plugin Maven Mojo", 0 );
        append( sb, "Maven plugin to run JUnit tests in parallel", 1 );
        append( sb, "", 0 );

        if ( goal == null || goal.length() <= 0 )
        {
            append( sb, "This plugin has 2 goals:", 0 );
            append( sb, "", 0 );
        }

        if ( goal == null || goal.length() <= 0 || "help".equals( goal ) )
        {
            append( sb, "junit:help", 0 );
            append( sb, "Display help information on maven-junit-plugin.\nCall\n\u00a0\u00a0mvn\u00a0junit:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "detail (Default: false)", 2 );
                append( sb, "If true, display all settable properties for each goal.", 3 );
                append( sb, "Expression: ${detail}", 3 );
                append( sb, "", 0 );

                append( sb, "goal", 2 );
                append( sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3 );
                append( sb, "Expression: ${goal}", 3 );
                append( sb, "", 0 );

                append( sb, "indentSize (Default: 2)", 2 );
                append( sb, "The number of spaces per indentation level, should be positive.", 3 );
                append( sb, "Expression: ${indentSize}", 3 );
                append( sb, "", 0 );

                append( sb, "lineLength (Default: 80)", 2 );
                append( sb, "The maximum length of a display line, should be positive.", 3 );
                append( sb, "Expression: ${lineLength}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( goal == null || goal.length() <= 0 || "test".equals( goal ) )
        {
            append( sb, "junit:test", 0 );
            append( sb, "Runs tests", 1 );
            append( sb, "", 0 );
            if ( detail )
            {
                append( sb, "Available parameters:", 1 );
                append( sb, "", 0 );

                append( sb, "argLine", 2 );
                append( sb, "Arbitrary JVM options to set on the command line. Used when forking.", 3 );
                append( sb, "Expression: ${argLine}", 3 );
                append( sb, "", 0 );

                append( sb, "concurrency", 2 );
                append( sb, "Number of concurrent executions. Specify -N means \'N times #ofProcessors\'", 3 );
                append( sb, "Expression: ${maven.junit.concurrency}", 3 );
                append( sb, "", 0 );

                append( sb, "debugForkedProcess", 2 );
                append( sb, "Attach a debugger to the forked JVM. If set to \'true\', the process will suspend and wait for a debugger to attach on port 5005. If set to some other string, that string will be appended to the argLine, allowing you to configure arbitrary debuggability options (without overwriting the other options specified in the argLine).", 3 );
                append( sb, "Expression: ${maven.surefire.debug}", 3 );
                append( sb, "", 0 );

                append( sb, "excludes", 2 );
                append( sb, "A list of <exclude> elements specifying the tests (by pattern) that should be excluded in testing. When not specified and when the test parameter is not specified, the default excludes will be \n<excludes>\n\u00a0<exclude>**/*$*</exclude>\n</excludes>\n(which excludes all inner classes).\nThis parameter is ignored if the TestNG suiteXmlFiles parameter is specified.", 3 );
                append( sb, "", 0 );

                append( sb, "fork", 2 );
                append( sb, "Option to specify the forking behavior. True to fork, false to run in process.", 3 );
                append( sb, "Expression: ${maven.junit.fork}", 3 );
                append( sb, "", 0 );

                append( sb, "project", 2 );
                append( sb, "(no description available)", 3 );
                append( sb, "Required: Yes", 3 );
                append( sb, "Expression: ${project}", 3 );
                append( sb, "", 0 );

                append( sb, "quiet (Default: true)", 2 );
                append( sb, "If true, the stdout/stderr from tests will not be copied to the console. (Note that they are always in the test result XML file, regardless of the value of this option.)", 3 );
                append( sb, "Expression: ${maven.junit.quiet}", 3 );
                append( sb, "", 0 );

                append( sb, "reportsDirectory", 2 );
                append( sb, "Base directory where all reports are written to.", 3 );
                append( sb, "Expression: ${project.build.directory}/surefire-reports", 3 );
                append( sb, "", 0 );

                append( sb, "skipTests", 2 );
                append( sb, "Set this to \'true\' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3 );
                append( sb, "Expression: ${skipTests}", 3 );
                append( sb, "", 0 );

                append( sb, "systemProperties", 2 );
                append( sb, "List of System properties to pass to the JUnit tests.", 3 );
                append( sb, "", 0 );

                append( sb, "test", 2 );
                append( sb, "Specify this parameter to run individual tests by file name, overriding the includes/excludes parameters. Each pattern you specify here will be used to create an include pattern formatted like **/${test}.java, so you can just type \'-Dtest=MyTest\' to run a single test called \'foo/MyTest.java\'. This parameter will override the TestNG suiteXmlFiles parameter. since 1.7 you can now use \'-Dtest=MyTest#method\' to execute only one method of the unit tests. Note * is supported too \'-Dtest=MyTest#method*\' to execute only method starting with method", 3 );
                append( sb, "Expression: ${test}", 3 );
                append( sb, "", 0 );

                append( sb, "testFailureIgnore", 2 );
                append( sb, "Set this to true to ignore a failure during testing. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3 );
                append( sb, "Expression: ${maven.test.failure.ignore}", 3 );
                append( sb, "", 0 );

                append( sb, "timeout", 2 );
                append( sb, "Abort the test if it doesn\'t complete in the given number of seconds. 0 means no timeout.", 3 );
                append( sb, "Expression: ${maven.junit.timeout}", 3 );
                append( sb, "", 0 );
            }
        }

        if ( getLog().isInfoEnabled() )
        {
            getLog().info( sb.toString() );
        }
    }

    /**
     * <p>Repeat a String <code>n</code> times to form a new string.</p>
     *
     * @param str String to repeat
     * @param repeat number of times to repeat str
     * @return String with repeated String
     * @throws NegativeArraySizeException if <code>repeat < 0</code>
     * @throws NullPointerException if str is <code>null</code>
     */
    private static String repeat( String str, int repeat )
    {
        StringBuffer buffer = new StringBuffer( repeat * str.length() );

        for ( int i = 0; i < repeat; i++ )
        {
            buffer.append( str );
        }

        return buffer.toString();
    }

    /** 
     * Append a description to the buffer by respecting the indentSize and lineLength parameters.
     * <b>Note</b>: The last character is always a new line.
     * 
     * @param sb The buffer to append the description, not <code>null</code>.
     * @param description The description, not <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     */
    private void append( StringBuffer sb, String description, int indent )
    {
        for ( Iterator it = toLines( description, indent, indentSize, lineLength ).iterator(); it.hasNext(); )
        {
            sb.append( it.next().toString() ).append( '\n' );
        }
    }

    /** 
     * Splits the specified text into lines of convenient display length.
     * 
     * @param text The text to split into lines, must not be <code>null</code>.
     * @param indent The base indentation level of each line, must not be negative.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     * @return The sequence of display lines, never <code>null</code>.
     * @throws NegativeArraySizeException if <code>indent < 0</code>
     */
    private static List toLines( String text, int indent, int indentSize, int lineLength )
    {
        List lines = new ArrayList();

        String ind = repeat( "\t", indent );
        String[] plainLines = text.split( "(\r\n)|(\r)|(\n)" );
        for ( int i = 0; i < plainLines.length; i++ )
        {
            toLines( lines, ind + plainLines[i], indentSize, lineLength );
        }

        return lines;
    }

    /** 
     * Adds the specified line to the output sequence, performing line wrapping if necessary.
     * 
     * @param lines The sequence of display lines, must not be <code>null</code>.
     * @param line The line to add, must not be <code>null</code>.
     * @param indentSize The size of each indentation, must not be negative.
     * @param lineLength The length of the line, must not be negative.
     */
    private static void toLines( List lines, String line, int indentSize, int lineLength )
    {
        int lineIndent = getIndentLevel( line );
        StringBuffer buf = new StringBuffer( 256 );
        String[] tokens = line.split( " +" );
        for ( int i = 0; i < tokens.length; i++ )
        {
            String token = tokens[i];
            if ( i > 0 )
            {
                if ( buf.length() + token.length() >= lineLength )
                {
                    lines.add( buf.toString() );
                    buf.setLength( 0 );
                    buf.append( repeat( " ", lineIndent * indentSize ) );
                }
                else
                {
                    buf.append( ' ' );
                }
            }
            for ( int j = 0; j < token.length(); j++ )
            {
                char c = token.charAt( j );
                if ( c == '\t' )
                {
                    buf.append( repeat( " ", indentSize - buf.length() % indentSize ) );
                }
                else if ( c == '\u00A0' )
                {
                    buf.append( ' ' );
                }
                else
                {
                    buf.append( c );
                }
            }
        }
        lines.add( buf.toString() );
    }

    /** 
     * Gets the indentation level of the specified line.
     * 
     * @param line The line whose indentation level should be retrieved, must not be <code>null</code>.
     * @return The indentation level of the line.
     */
    private static int getIndentLevel( String line )
    {
        int level = 0;
        for ( int i = 0; i < line.length() && line.charAt( i ) == '\t'; i++ )
        {
            level++;
        }
        for ( int i = level + 1; i <= level + 4 && i < line.length(); i++ )
        {
            if ( line.charAt( i ) == '\t' )
            {
                level++;
                break;
            }
        }
        return level;
    }
}
