/*
 * Decompiled with CFR 0.152.
 */
package com.sun.maven.junit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.kohsuke:maven-junit-plugin:1.11", 0);
        this.append(sb, "", 0);
        this.append(sb, "maven-junit-plugin Maven Mojo", 0);
        this.append(sb, "Maven plugin to run JUnit tests in parallel", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "junit:help", 0);
            this.append(sb, "Display help information on maven-junit-plugin.\nCall\n\u00a0\u00a0mvn\u00a0junit:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test".equals(this.goal)) {
            this.append(sb, "junit:test", 0);
            this.append(sb, "Runs tests", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "argLine", 2);
                this.append(sb, "Arbitrary JVM options to set on the command line. Used when forking.", 3);
                this.append(sb, "Expression: ${argLine}", 3);
                this.append(sb, "", 0);
                this.append(sb, "concurrency", 2);
                this.append(sb, "Number of concurrent executions. Specify -N means 'N times #ofProcessors'", 3);
                this.append(sb, "Expression: ${maven.junit.concurrency}", 3);
                this.append(sb, "", 0);
                this.append(sb, "debugForkedProcess", 2);
                this.append(sb, "Attach a debugger to the forked JVM. If set to 'true', the process will suspend and wait for a debugger to attach on port 5005. If set to some other string, that string will be appended to the argLine, allowing you to configure arbitrary debuggability options (without overwriting the other options specified in the argLine).", 3);
                this.append(sb, "Expression: ${maven.surefire.debug}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of <exclude> elements specifying the tests (by pattern) that should be excluded in testing. When not specified and when the test parameter is not specified, the default excludes will be \n<excludes>\n\u00a0<exclude>**/*$*</exclude>\n</excludes>\n(which excludes all inner classes).\nThis parameter is ignored if the TestNG suiteXmlFiles parameter is specified.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fork", 2);
                this.append(sb, "Option to specify the forking behavior. True to fork, false to run in process.", 3);
                this.append(sb, "Expression: ${maven.junit.fork}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${project}", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: true)", 2);
                this.append(sb, "If true, the stdout/stderr from tests will not be copied to the console. (Note that they are always in the test result XML file, regardless of the value of this option.)", 3);
                this.append(sb, "Expression: ${maven.junit.quiet}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsDirectory", 2);
                this.append(sb, "Base directory where all reports are written to.", 3);
                this.append(sb, "Expression: ${project.build.directory}/surefire-reports", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipTests", 2);
                this.append(sb, "Set this to 'true' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "Expression: ${skipTests}", 3);
                this.append(sb, "", 0);
                this.append(sb, "systemProperties", 2);
                this.append(sb, "List of System properties to pass to the JUnit tests.", 3);
                this.append(sb, "", 0);
                this.append(sb, "test", 2);
                this.append(sb, "Specify this parameter to run individual tests by file name, overriding the includes/excludes parameters. Each pattern you specify here will be used to create an include pattern formatted like **/${test}.java, so you can just type '-Dtest=MyTest' to run a single test called 'foo/MyTest.java'. This parameter will override the TestNG suiteXmlFiles parameter. since 1.7 you can now use '-Dtest=MyTest#method' to execute only one method of the unit tests. Note * is supported too '-Dtest=MyTest#method*' to execute only method starting with method", 3);
                this.append(sb, "Expression: ${test}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testFailureIgnore", 2);
                this.append(sb, "Set this to true to ignore a failure during testing. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "Expression: ${maven.test.failure.ignore}", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout", 2);
                this.append(sb, "Abort the test if it doesn't complete in the given number of seconds. 0 means no timeout.", 3);
                this.append(sb, "Expression: ${maven.junit.timeout}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

