/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.maven.pgp.loaders;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPUtil;
import org.codehaus.plexus.component.annotations.Component;
import org.kohsuke.maven.pgp.PgpMojo;
import org.kohsuke.maven.pgp.SecretKeyLoader;

@Component(role=SecretKeyLoader.class, hint="keyfile")
public class KeyFileLoader
extends SecretKeyLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PGPSecretKey load(PgpMojo mojo, String keyFile) throws IOException {
        FileInputStream in = new FileInputStream(new File(keyFile));
        try {
            PGPObjectFactory pgpF = new PGPObjectFactory(PGPUtil.getDecoderStream((InputStream)in));
            Object o = pgpF.nextObject();
            if (!(o instanceof PGPSecretKeyRing)) {
                throw new IOException(keyFile + " doesn't contain PGP private key");
            }
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)o;
            PGPSecretKey pGPSecretKey = keyRing.getSecretKey();
            return pGPSecretKey;
        }
        finally {
            in.close();
        }
    }
}

