/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.extensibility;

import com.cloudbees.sdk.extensibility.ExtensionFinder;
import com.cloudbees.sdk.extensibility.ExtensionList;
import com.cloudbees.sdk.extensibility.lifecycle.Startable;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.extensibility.GuiceFacet;
import org.kohsuke.stapler.extensibility.InjectorHolder;
import org.kohsuke.stapler.framework.AbstractWebAppMain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensibleWebAppMain<T>
extends AbstractWebAppMain<T> {
    private ClassLoader world;

    protected ExtensibleWebAppMain(Class<T> rootType) {
        super(rootType);
    }

    public Object createApplication() throws Exception {
        Injector injector;
        ((GuiceFacet)WebApp.get((ServletContext)this.context).getFacet(GuiceFacet.class)).injector = injector = this.createInjector();
        InjectorHolder.HOLDER = new InjectorHolder(){

            public Injector get() {
                return injector;
            }
        };
        for (Startable s : new ExtensionList(Startable.class).list(injector)) {
            try {
                s.start();
            }
            catch (Exception e) {
                throw new Exception(s + " failed to start", e);
            }
        }
        return injector.getInstance(this.rootType);
    }

    public Injector createInjector() {
        this.world = this.createWorld();
        Thread.currentThread().setContextClassLoader(this.world);
        ArrayList<Module> modules = new ArrayList<Module>();
        this.assembleModules(modules);
        return Guice.createInjector(modules);
    }

    protected void assembleModules(List<Module> modules) {
        modules.add((Module)new ExtensionFinder(this.world));
        modules.add((Module)new AbstractModule(){

            protected void configure() {
                this.bind(ClassLoader.class).toInstance((Object)ExtensibleWebAppMain.this.world);
                this.bind(ServletContext.class).toInstance((Object)ExtensibleWebAppMain.this.context);
                this.bind(ExtensibleWebAppMain.this.rootType).to(ExtensibleWebAppMain.this.rootType);
            }
        });
    }

    protected ClassLoader createWorld() {
        return Thread.currentThread().getContextClassLoader();
    }
}

