/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.jruby;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.MetaClass;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.JellyCompatibleFacet;
import org.kohsuke.stapler.jelly.JellyFacet;
import org.kohsuke.stapler.jelly.jruby.AbstractRubyTearOff;
import org.kohsuke.stapler.jelly.jruby.RackDispatcher;
import org.kohsuke.stapler.jelly.jruby.RubyKlassNavigator;
import org.kohsuke.stapler.jelly.jruby.RubyTemplateContainer;
import org.kohsuke.stapler.jelly.jruby.RubyTemplateLanguage;
import org.kohsuke.stapler.jelly.jruby.ScriptInvokingDispatcher;
import org.kohsuke.stapler.jelly.jruby.erb.ERbClassTearOff;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.lang.KlassNavigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRubyFacet
extends Facet
implements JellyCompatibleFacet {
    final List<RubyTemplateLanguage> languages = new CopyOnWriteArrayList<RubyTemplateLanguage>();
    private final ScriptingContainer container;
    private final RubyKlassNavigator navigator;
    private final Map<String, RubyTemplateContainer> templateContainers = new HashMap<String, RubyTemplateContainer>();
    private final Collection<Class<? extends AbstractRubyTearOff>> tearOffTypes = new CopyOnWriteArrayList<Class<? extends AbstractRubyTearOff>>();

    public JRubyFacet() {
        this.languages.addAll(Facet.discoverExtensions(RubyTemplateLanguage.class, (ClassLoader[])new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()}));
        this.container = new ScriptingContainer(LocalContextScope.SINGLETHREAD);
        this.container.runScriptlet("require 'org/kohsuke/stapler/jelly/jruby/JRubyJellyScriptImpl'");
        this.navigator = new RubyKlassNavigator(this.container.getProvider().getRuntime(), ((Object)((Object)this)).getClass().getClassLoader());
        for (RubyTemplateLanguage l : this.languages) {
            this.templateContainers.put(l.getScriptExtension(), l.createContainer(this.container));
            this.tearOffTypes.add(l.getTearOffClass());
        }
    }

    private RubyTemplateContainer selectTemplateContainer(String path) {
        RubyTemplateContainer t;
        int idx = path.lastIndexOf(46);
        if (idx >= 0 && (t = this.templateContainers.get(path.substring(idx))) != null) {
            return t;
        }
        throw new IllegalArgumentException("Unrecognized file extension: " + path);
    }

    public Script parseScript(URL template) throws IOException {
        return this.selectTemplateContainer(template.getPath()).parseScript(template);
    }

    public Klass<RubyModule> getKlass(Object o) {
        if (o instanceof RubyObject) {
            return this.makeKlass((RubyModule)((RubyObject)o).getMetaClass());
        }
        return null;
    }

    private Klass<RubyModule> makeKlass(RubyModule o) {
        return new Klass((Object)o, (KlassNavigator)this.navigator);
    }

    public synchronized MetaClass getClassInfo(RubyClass r) {
        return WebApp.getCurrent().getMetaClass(this.makeKlass((RubyModule)r));
    }

    private boolean isRuby(MetaClass mc) {
        return mc.klass.clazz instanceof RubyModule;
    }

    public void buildViewDispatchers(final MetaClass owner, List<Dispatcher> dispatchers) {
        for (final Class<? extends AbstractRubyTearOff> t : this.getClassTearOffTypes()) {
            dispatchers.add(new ScriptInvokingDispatcher(){
                final AbstractRubyTearOff tearOff;
                {
                    this.tearOff = (AbstractRubyTearOff)((Object)owner.loadTearOff(t));
                }

                public boolean dispatch(RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException {
                    String next = req.tokens.peek();
                    if (next == null) {
                        return false;
                    }
                    if (req.tokens.countRemainingTokens() > 1) {
                        return false;
                    }
                    if (req.getRequestURI().endsWith("/")) {
                        return false;
                    }
                    return this.invokeScript(req, rsp, node, next, (Script)this.tearOff.findScript(next));
                }
            });
        }
    }

    public void buildFallbackDispatchers(MetaClass owner, List<Dispatcher> dispatchers) {
        if (this.isRuby(owner)) {
            dispatchers.add(new RackDispatcher());
        }
    }

    public Collection<Class<? extends AbstractRubyTearOff>> getClassTearOffTypes() {
        return this.tearOffTypes;
    }

    public Collection<String> getScriptExtensions() {
        ArrayList<String> r = new ArrayList<String>();
        for (RubyTemplateLanguage l : this.languages) {
            r.add(l.getScriptExtension());
        }
        return r;
    }

    public RequestDispatcher createRequestDispatcher(RequestImpl request, Klass<?> type, Object it, String viewName) throws IOException {
        MetaClass mc = request.stapler.getWebApp().getMetaClass(type);
        return ((ERbClassTearOff)((Object)mc.loadTearOff(ERbClassTearOff.class))).createDispatcher(it, viewName);
    }

    public boolean handleIndexRequest(RequestImpl req, ResponseImpl rsp, Object node, MetaClass mc) throws IOException, ServletException {
        for (Class<? extends AbstractRubyTearOff> t : this.getClassTearOffTypes()) {
            AbstractRubyTearOff rt = (AbstractRubyTearOff)((Object)mc.loadTearOff(t));
            Script script = (Script)rt.findScript("index");
            if (script == null) continue;
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Invoking index" + rt.getDefaultScriptExtension() + " on " + node);
                }
                ((JellyFacet)WebApp.getCurrent().getFacet(JellyFacet.class)).scriptInvoker.invokeScript((StaplerRequest)req, (StaplerResponse)rsp, script, node);
                return true;
            }
            catch (JellyTagException e) {
                throw new ServletException((Throwable)e);
            }
        }
        return false;
    }
}

