/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.jruby;

import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.ConstantExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.impl.TagScript;
import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.kohsuke.stapler.jelly.jruby.IJRubyContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JRubyJellyScript
implements Script {
    protected JRubyJellyScript() {
    }

    public Script compile() throws JellyException {
        return this;
    }

    public abstract void run(JellyContext var1, XMLOutput var2) throws JellyTagException;

    public void invokeTaglib(final IJRubyContext rcon, JellyContext context, XMLOutput output, String uri, String localName, Map<RubySymbol, ?> attributes, final RubyProc proc) throws JellyException {
        TagScript tagScript = this.createTagScript(context, uri, localName);
        if (attributes != null) {
            for (Map.Entry<RubySymbol, ?> e : attributes.entrySet()) {
                tagScript.addAttribute(e.getKey().asJavaString(), (Expression)new ConstantExpression(e.getValue()));
            }
        }
        if (proc != null) {
            final Ruby runtime = ((IRubyObject)rcon).getRuntime();
            tagScript.setTagBody(new Script(){

                public Script compile() throws JellyException {
                    return this;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run(JellyContext context, XMLOutput output) throws JellyTagException {
                    JellyContext oc = rcon.getJellyContext();
                    XMLOutput oo = rcon.getOutput();
                    try {
                        rcon.setJellyContext(context);
                        rcon.setOutput(output);
                        proc.getBlock().yield(runtime.getCurrentContext(), null);
                    }
                    finally {
                        rcon.setJellyContext(oc);
                        rcon.setOutput(oo);
                    }
                }
            });
        }
        tagScript.run(context, output);
    }

    private TagScript createTagScript(JellyContext context, String uri, String name) throws JellyException {
        TagLibrary lib = context.getTagLibrary(uri);
        if (lib == null) {
            throw new JellyException("Undefined tag library namespace URI: " + uri);
        }
        TagScript tagScript = lib.createTagScript(name, null);
        if (tagScript != null) {
            return tagScript;
        }
        tagScript = lib.createTagScript(name.replace('_', '-'), null);
        if (tagScript != null) {
            return tagScript;
        }
        throw new JellyException(String.format("name '%s' not found for '%s'", name, uri));
    }
}

