/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.jruby;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.kohsuke.stapler.MetaClassLoader;
import org.kohsuke.stapler.jelly.jruby.RubyMethodRef;
import org.kohsuke.stapler.lang.Klass;
import org.kohsuke.stapler.lang.KlassNavigator;
import org.kohsuke.stapler.lang.MethodRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RubyKlassNavigator
extends KlassNavigator<RubyModule> {
    private final Ruby ruby;
    private final ClassLoader classLoader;

    public RubyKlassNavigator(Ruby ruby, ClassLoader cl) {
        this.ruby = ruby;
        this.classLoader = cl;
    }

    public URL getResource(RubyModule clazz, String resourceName) {
        URL res;
        String fullName = resourceName.startsWith("/") ? resourceName.substring(1) : RubyKlassNavigator.decamelize(clazz.getName().replace("::", "/") + '/' + resourceName);
        if (MetaClassLoader.debugLoader != null && (res = MetaClassLoader.debugLoader.loader.getResource(fullName)) != null) {
            return res;
        }
        return this.classLoader.getResource(fullName);
    }

    public Iterable<Klass<?>> getAncestors(RubyModule clazz) {
        ArrayList r = new ArrayList();
        for (RubyModule anc : clazz.getAncestorList()) {
            r.add(this.wrap(anc));
        }
        return r;
    }

    public Klass<?> getSuperClass(RubyModule clazz) {
        return this.wrap((RubyModule)clazz.getSuperClass());
    }

    public List<MethodRef> getDeclaredMethods(RubyModule clazz) {
        ArrayList<MethodRef> r = new ArrayList<MethodRef>();
        for (DynamicMethod m : clazz.getMethods().values()) {
            if (m.getImplementationClass() != clazz) continue;
            r.add(new RubyMethodRef(clazz, m));
        }
        return r;
    }

    public Class toJavaClass(RubyModule clazz) {
        RubyClass rc;
        Class c;
        if (clazz instanceof RubyClass && (c = (rc = (RubyClass)clazz).getReifiedClass()) != null) {
            return c;
        }
        return RubyObject.class;
    }

    public Klass<RubyModule> wrap(RubyModule m) {
        return m == null ? null : new Klass((Object)m, (KlassNavigator)this);
    }

    static String decamelize(String s) {
        return s.replaceAll("(\\p{javaLetterOrDigit})(\\p{javaUpperCase}\\p{javaLowerCase})", "$1_$2").replaceAll("(\\p{javaLowerCase})(\\p{javaUpperCase})", "$1_$2").toLowerCase(Locale.ENGLISH);
    }
}

