/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler.jelly.jruby;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.rack.DefaultRackApplication;
import org.jruby.rack.RackContext;
import org.jruby.rack.RackEnvironment;
import org.jruby.rack.RackResponseEnvironment;
import org.jruby.rack.servlet.DefaultServletRackContext;
import org.jruby.rack.servlet.ServletRackConfig;
import org.jruby.rack.servlet.ServletRackEnvironment;
import org.jruby.rack.servlet.ServletRackResponseEnvironment;
import org.jruby.runtime.builtin.IRubyObject;
import org.kohsuke.stapler.Dispatcher;
import org.kohsuke.stapler.RequestImpl;
import org.kohsuke.stapler.ResponseImpl;
import org.kohsuke.stapler.Stapler;

public class RackDispatcher
extends Dispatcher {
    public boolean dispatch(final RequestImpl req, ResponseImpl rsp, Object node) throws IOException, ServletException, IllegalAccessException, InvocationTargetException {
        RubyObject x = (RubyObject)node;
        Ruby runtime = x.getRuntime();
        DynamicMethod m = x.getMetaClass().searchMethod("call");
        if (m == null) {
            return false;
        }
        DefaultServletRackContext rackContext = new DefaultServletRackContext(new ServletRackConfig(req.getServletContext()));
        ServletRackEnvironment env = new ServletRackEnvironment((HttpServletRequest)req, (HttpServletResponse)rsp, (RackContext)rackContext){

            public String getPathInfo() {
                return req.getRestOfPath();
            }
        };
        runtime.getLoadService().require("rack/handler/servlet");
        IRubyObject servletHandler = ((RubyModule)runtime.getModule("Rack").getConstantAt("Handler")).getClass("Servlet").callMethod("new", new IRubyObject[]{x});
        DefaultRackApplication dra = new DefaultRackApplication();
        dra.setApplication(servletHandler);
        dra.call((RackEnvironment)env).respond((RackResponseEnvironment)new ServletRackResponseEnvironment((HttpServletResponse)Stapler.getCurrentResponse()));
        return true;
    }

    public String toString() {
        return "call(env) to delegate to Rack-compatible Ruby objects";
    }
}

