/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.maven.rewrite;

import org.kohsuke.maven.rewrite.XmlPatcher;

public class Mark {
    int s;
    int e;
    private final XmlPatcher patcher;

    Mark(XmlPatcher patcher) {
        this.patcher = patcher;
        patcher.marks.add(this);
    }

    public void clear() {
        this.e = -1;
        this.s = -1;
        this.patcher.marks.remove(this);
    }

    boolean isSet() {
        return this.s != -1;
    }

    public String verbatim() {
        return this.isSet() ? this.patcher.xml.substring(this.s, this.e) : "";
    }

    public void replace(String replacement) {
        if (!this.isSet()) {
            throw new IllegalStateException();
        }
        this.patcher.xml.replace(this.s, this.e, replacement);
        int d = replacement.length() - this.length();
        this.patcher.updateMarks(this, d);
    }

    public void set() {
        this.set(this.patcher.getLast());
    }

    void set(int start, int end) {
        this.s = start;
        this.e = end;
    }

    public boolean isLeftOf(Mark that) {
        return this.e <= that.s;
    }

    public boolean isRightOf(Mark that) {
        return that.isLeftOf(this);
    }

    int length() {
        return this.e - this.s;
    }

    public void set(Mark that) {
        this.s = that.s;
        this.e = that.e;
    }

    void update(Mark that, int delta) {
        if (!this.isSet() || delta == 0) {
            return;
        }
        if (this.isLeftOf(that)) {
            return;
        }
        if (that.isLeftOf(this)) {
            this.shift(delta);
            return;
        }
        if (this.contains(that)) {
            this.grow(delta);
            return;
        }
        this.clear();
    }

    void shift(int delta) {
        this.s += delta;
        this.e += delta;
    }

    void grow(int delta) {
        this.e += delta;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Mark mark = (Mark)o;
        return this.e == mark.e && this.s == mark.s;
    }

    public int hashCode() {
        int result = this.s;
        result = 31 * result + this.e;
        return result;
    }

    public boolean contains(Mark that) {
        return this.s <= that.s && that.e <= this.e;
    }

    public Mark to(Mark that) {
        return Mark.between(this, that);
    }

    public Mark toCurrent() {
        return Mark.between(this, this.patcher.getLast());
    }

    public String toString() {
        return this.verbatim();
    }

    static Mark between(Mark a, Mark b) {
        if (a.isSet() && b.isSet() && a.isLeftOf(b)) {
            Mark m = new Mark(a.patcher);
            m.set(a.e, b.s);
            return m;
        }
        throw new IllegalStateException();
    }
}

