/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.maven.rewrite;

import com.ctc.wstx.stax.WstxInputFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.IOUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.stax2.XMLInputFactory2;
import org.kohsuke.maven.rewrite.Mark;
import org.kohsuke.maven.rewrite.XmlPath;
import org.kohsuke.maven.rewrite.XmlVisitor;

public class XmlPatcher
implements XMLEventReader {
    final StringBuilder xml;
    private boolean modified = false;
    private XMLInputFactory factory;
    final Set<Mark> marks = new HashSet<Mark>();
    private final Mark lastPos = new Mark(this);
    private final Mark nextPos = new Mark(this);
    private int cumulativeDelta = 0;
    private XMLEvent next = null;
    private XMLEventReader backing;
    private XmlPath path;

    public XmlPatcher(StringBuilder xml) {
        this.xml = xml;
    }

    public XmlPatcher(File f) throws IOException {
        this(new FileInputStream(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlPatcher(InputStream in) throws IOException {
        XmlStreamReader r = new XmlStreamReader(in);
        try {
            this.xml = new StringBuilder(IOUtils.toString((Reader)r));
        }
        finally {
            r.close();
        }
    }

    private static XMLInputFactory2 createDefaultXMLInputFactory() {
        WstxInputFactory xif = new WstxInputFactory();
        xif.setProperty("org.codehaus.stax2.preserveLocation", (Object)Boolean.TRUE);
        return xif;
    }

    public void setFactory(XMLInputFactory factory) {
        this.factory = factory;
    }

    public void rewind() throws XMLStreamException {
        if (this.factory == null) {
            this.factory = XmlPatcher.createDefaultXMLInputFactory();
        }
        this.backing = this.factory.createXMLEventReader(new StringReader(this.xml.toString()));
        this.marks.clear();
        this.cumulativeDelta = 0;
        this.nextPos.set(0, 0);
        this.lastPos.clear();
        this.next = null;
    }

    public XmlPath getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scan(XmlVisitor v) throws XMLStreamException {
        if (this.path != null) {
            throw new IllegalStateException("XmlScanner is not re-entrant");
        }
        this.path = null;
        this.rewind();
        try {
            this.rewind();
            v.startDocument(this);
            while (this.hasNext()) {
                XMLEvent event = this.nextEvent();
                if (event.isStartElement()) {
                    this.path = new XmlPath(this.path, event.asStartElement());
                    v.startElement();
                }
                if (!event.isEndElement()) continue;
                v.endElement();
                this.path = this.path.getParent();
            }
            boolean bl = this.isModified();
            return bl;
        }
        finally {
            this.path = null;
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public Object next() {
        try {
            return this.nextEvent();
        }
        catch (XMLStreamException e) {
            return null;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLEvent nextEvent() throws XMLStreamException {
        try {
            XMLEvent xMLEvent = this.next;
            return xMLEvent;
        }
        finally {
            this.next = null;
            this.lastPos.set(this.nextPos);
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        return this.backing.peek();
    }

    public String getElementText() throws XMLStreamException {
        return this.backing.getElementText();
    }

    public XMLEvent nextTag() throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent e = this.nextEvent();
            if (e.isCharacters() && !((Characters)e).isWhiteSpace()) {
                throw new XMLStreamException("Unexpected text");
            }
            if (!e.isStartElement() && !e.isEndElement()) continue;
            return e;
        }
        throw new XMLStreamException("Unexpected end of Document");
    }

    public Object getProperty(String name) {
        return this.backing.getProperty(name);
    }

    public void close() throws XMLStreamException {
        this.backing.close();
        this.next = null;
        this.backing = null;
    }

    public StringBuilder asStringBuilder() {
        return new StringBuilder(this.xml.toString());
    }

    public String getPeekVerbatim() {
        if (this.hasNext()) {
            return this.nextPos.verbatim();
        }
        return "";
    }

    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (!this.backing.hasNext()) {
            return false;
        }
        try {
            int s;
            this.next = this.backing.nextEvent();
            int e = s = this.nextPos.e;
            if (this.backing.hasNext()) {
                e = this.backing.peek().getLocation().getCharacterOffset() + this.cumulativeDelta;
            }
            if (e != -1) {
                if (!this.next.isCharacters()) {
                    while (s < e && s < this.xml.length() && (this.c(s) == '\n' || this.c(s) == '\r')) {
                        ++s;
                    }
                    this.nextPos.set(s, e);
                } else {
                    this.nextPos.set(s, e);
                    while (this.nextEndIncludesNextEvent() || this.nextEndIncludesNextEndElement()) {
                        this.nextPos.grow(-1);
                    }
                }
            } else {
                this.nextPos.set(s, e);
            }
            return s < this.xml.length();
        }
        catch (XMLStreamException e) {
            return false;
        }
    }

    public Mark getLast() {
        return this.lastPos;
    }

    public Mark mark() {
        return new Mark(this);
    }

    private boolean nextEndIncludesNextEndElement() {
        return this.nextPos.length() > 2 && this.c(this.nextPos.e - 2) == '<';
    }

    private boolean nextEndIncludesNextEvent() {
        return this.nextPos.length() > 1 && (this.c(this.nextPos.e - 1) == '<' || this.c(this.nextPos.e - 1) == '&');
    }

    private char c(int index) {
        return this.xml.charAt(index);
    }

    public void replace(String replacement) {
        this.lastPos.replace(replacement);
    }

    public String getBetween(Mark a, Mark b) {
        return Mark.between(a, b).verbatim();
    }

    public void replaceBetween(Mark a, Mark b, String replacement) {
        Mark.between(a, b).replace(replacement);
    }

    void updateMarks(Mark changed, int delta) {
        if (delta == 0) {
            return;
        }
        this.nextPos.update(changed, delta);
        this.lastPos.update(changed, delta);
        for (Mark m : this.marks) {
            if (m == changed) continue;
            m.update(changed, delta);
        }
        changed.grow(delta);
        this.cumulativeDelta += delta;
        this.modified = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(File f) throws IOException {
        XmlStreamWriter writer = WriterFactory.newXmlWriter((File)f);
        try {
            writer.write(this.xml.toString());
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }
}

