/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.maven.rewrite;

import javax.xml.stream.events.StartElement;

public class XmlPath {
    private final XmlPath parent;
    private final StartElement tag;
    private final int depth;
    private final String localName;

    XmlPath(XmlPath parent, StartElement tag) {
        this.parent = parent;
        this.tag = tag;
        if (parent == null) {
            this.depth = 0;
            this.localName = '/' + tag.getName().getLocalPart();
        } else {
            this.depth = parent.depth + 1;
            this.localName = parent.getLocalNames() + '/' + tag.getName().getLocalPart();
        }
    }

    public XmlPath getParent() {
        return this.parent;
    }

    public StartElement getTag() {
        return this.tag;
    }

    public String getLocalNames() {
        return this.localName;
    }

    public int getDepth() {
        return this.depth;
    }

    public String toString() {
        return this.getLocalNames();
    }
}

