/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.maven.rewrite.edit;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.Set;
import org.kohsuke.maven.rewrite.Mark;
import org.kohsuke.maven.rewrite.XmlPatcher;
import org.kohsuke.maven.rewrite.XmlPath;
import org.kohsuke.maven.rewrite.XmlVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InsertInElement
extends XmlVisitor {
    private final Predicate<XmlPath> matcher;
    private XmlPath lastStart;
    private final Set<XmlPath> rewritten = new HashSet<XmlPath>();
    private Mark start;

    public InsertInElement(Predicate<XmlPath> matcher) {
        this.matcher = matcher;
    }

    @Override
    public void startDocument(XmlPatcher scanner) {
        super.startDocument(scanner);
        this.rewritten.clear();
        this.start = this.getPatcher().mark();
    }

    @Override
    public void startElement() {
        this.lastStart = this.getPath();
        XmlPath parent = this.getPath().getParent();
        if (this.matcher.apply((Object)parent) && !this.rewritten.contains(parent)) {
            this.doInsert(parent);
        }
        this.start.set();
    }

    private void doInsert(XmlPath parent) {
        Mark r = this.start.toCurrent();
        String indent = r.verbatim();
        String inserted = this.insert();
        if (inserted != null && inserted.length() != 0) {
            r.replace(indent + inserted + indent);
            r.clear();
            this.rewritten.add(parent);
        }
    }

    @Override
    public void endElement() {
        if (this.matcher.apply((Object)this.getPath()) && this.lastStart == this.getPath()) {
            this.doInsert(this.getPath());
        }
        this.start.set();
    }

    protected abstract String insert();
}

