/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.treasuredata;

import org.komamitsu.fluency.Fluency;
import org.komamitsu.fluency.FluencyBuilder;
import org.komamitsu.fluency.ingester.Ingester;
import org.komamitsu.fluency.recordformat.RecordFormatter;
import org.komamitsu.fluency.treasuredata.ingester.TreasureDataIngester;
import org.komamitsu.fluency.treasuredata.ingester.sender.TreasureDataSender;
import org.komamitsu.fluency.treasuredata.recordformat.TreasureDataRecordFormatter;

public class FluencyBuilderForTreasureData
extends FluencyBuilder {
    private Integer senderRetryMax;
    private Integer senderRetryIntervalMillis;
    private Integer senderMaxRetryIntervalMillis;
    private Float senderRetryFactor;
    private Integer senderWorkBufSize;

    public FluencyBuilderForTreasureData() {
        this.setBufferChunkRetentionTimeMillis(30000);
    }

    public Integer getSenderRetryMax() {
        return this.senderRetryMax;
    }

    public void setSenderRetryMax(Integer senderRetryMax) {
        this.senderRetryMax = senderRetryMax;
    }

    public Integer getSenderRetryIntervalMillis() {
        return this.senderRetryIntervalMillis;
    }

    public void setSenderRetryIntervalMillis(Integer senderRetryIntervalMillis) {
        this.senderRetryIntervalMillis = senderRetryIntervalMillis;
    }

    public Integer getSenderMaxRetryIntervalMillis() {
        return this.senderMaxRetryIntervalMillis;
    }

    public void setSenderMaxRetryIntervalMillis(Integer senderMaxRetryIntervalMillis) {
        this.senderMaxRetryIntervalMillis = senderMaxRetryIntervalMillis;
    }

    public Float getSenderRetryFactor() {
        return this.senderRetryFactor;
    }

    public void setSenderRetryFactor(Float senderRetryFactor) {
        this.senderRetryFactor = senderRetryFactor;
    }

    public Integer getSenderWorkBufSize() {
        return this.senderWorkBufSize;
    }

    public void setSenderWorkBufSize(Integer senderWorkBufSize) {
        this.senderWorkBufSize = senderWorkBufSize;
    }

    public Fluency build(String apikey, String endpoint) {
        return this.buildFromIngester(this.buildRecordFormatter(), this.buildIngester(this.createSenderConfig(endpoint, apikey)));
    }

    public Fluency build(String apikey) {
        return this.buildFromIngester(this.buildRecordFormatter(), this.buildIngester(this.createSenderConfig(null, apikey)));
    }

    private TreasureDataSender.Config createSenderConfig(String endpoint, String apikey) {
        if (apikey == null) {
            throw new IllegalArgumentException("`apikey` should be set");
        }
        TreasureDataSender.Config senderConfig = new TreasureDataSender.Config();
        senderConfig.setApikey(apikey);
        if (endpoint != null) {
            senderConfig.setEndpoint(endpoint);
        }
        return senderConfig;
    }

    public String toString() {
        return "FluencyBuilder{senderRetryMax=" + this.senderRetryMax + ", senderRetryIntervalMillis=" + this.senderRetryIntervalMillis + ", senderMaxRetryIntervalMillis=" + this.senderMaxRetryIntervalMillis + ", senderRetryFactor=" + this.senderRetryFactor + ", senderWorkBufSize=" + this.senderWorkBufSize + "} " + super.toString();
    }

    private RecordFormatter buildRecordFormatter() {
        return new TreasureDataRecordFormatter();
    }

    private Ingester buildIngester(TreasureDataSender.Config senderConfig) {
        if (this.getSenderRetryMax() != null) {
            senderConfig.setRetryMax(this.getSenderRetryMax());
        }
        if (this.getSenderRetryIntervalMillis() != null) {
            senderConfig.setRetryIntervalMs(this.getSenderRetryIntervalMillis());
        }
        if (this.getSenderMaxRetryIntervalMillis() != null) {
            senderConfig.setMaxRetryIntervalMs(this.getSenderMaxRetryIntervalMillis());
        }
        if (this.getSenderRetryFactor() != null) {
            senderConfig.setRetryFactor(this.getSenderRetryFactor().floatValue());
        }
        if (this.getErrorHandler() != null) {
            senderConfig.setErrorHandler(this.getErrorHandler());
        }
        if (this.getSenderWorkBufSize() != null) {
            senderConfig.setWorkBufSize(this.getSenderWorkBufSize());
        }
        TreasureDataSender sender = new TreasureDataSender(senderConfig);
        return new TreasureDataIngester(sender);
    }
}

