/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.treasuredata.recordformat;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.komamitsu.fluency.EventTime;
import org.komamitsu.fluency.recordformat.RecordFormatter;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.msgpack.value.ImmutableMapValue;
import org.msgpack.value.StringValue;
import org.msgpack.value.Value;
import org.msgpack.value.ValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreasureDataRecordFormatter
extends RecordFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(TreasureDataRecordFormatter.class);
    private static final StringValue KEY_TIME = ValueFactory.newString((String)"time");
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());

    public TreasureDataRecordFormatter() {
        this(new Config());
    }

    public TreasureDataRecordFormatter(Config config) {
        super((RecordFormatter.Config)config);
        this.registerObjectMapperModules(this.objectMapper);
    }

    private long getEpoch(Object timestamp) {
        if (timestamp instanceof EventTime) {
            return ((EventTime)timestamp).getSeconds();
        }
        if (timestamp instanceof Number) {
            return ((Number)timestamp).longValue();
        }
        LOG.warn("Invalid timestamp. Using current time: timestamp={}", timestamp);
        return System.currentTimeMillis() / 1000L;
    }

    public byte[] format(String tag, Object timestamp, Map<String, Object> data) {
        Map<String, Object> record;
        if (data.get("time") == null) {
            record = new HashMap<String, Object>(data);
            long epoch = this.getEpoch(timestamp);
            record.put("time", epoch);
        } else {
            record = data;
        }
        try {
            return this.objectMapper.writeValueAsBytes(record);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(String.format("Failed to convert the record to MessagePack format: cause=%s, tag=%s, timestamp=%s, recordCount=%d", e.getMessage(), tag, timestamp, data.size()));
        }
    }

    private byte[] addTimeColumnToMsgpackRecord(MessageUnpacker unpacker, long timestamp, int mapValueLen) throws IOException {
        ImmutableMapValue mapValue = unpacker.unpackValue().asMapValue();
        int mapSize = mapValue.size();
        Value[] keyValueArray = mapValue.getKeyValueArray();
        boolean timeColExists = false;
        for (int i = 0; i < mapSize; ++i) {
            if (!keyValueArray[i * 2].asStringValue().equals(KEY_TIME)) continue;
            timeColExists = true;
            break;
        }
        try (ByteArrayOutputStream output = new ByteArrayOutputStream(mapValueLen + 16);){
            try (MessagePacker packer = MessagePack.newDefaultPacker((OutputStream)output);){
                if (timeColExists) {
                    packer.packMapHeader(mapSize);
                } else {
                    packer.packMapHeader(mapSize + 1);
                    packer.packString("time");
                    packer.packLong(timestamp);
                }
                for (int i = 0; i < mapSize; ++i) {
                    packer.packValue(keyValueArray[i * 2]);
                    packer.packValue(keyValueArray[i * 2 + 1]);
                }
            }
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] formatFromMessagePack(String tag, Object timestamp, byte[] mapValue, int offset, int len) {
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])mapValue, (int)offset, (int)len);){
            byte[] byArray = this.addTimeColumnToMsgpackRecord(unpacker, this.getEpoch(timestamp), len);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Failed to convert the record to MessagePack format: cause=%s, tag=%s, timestamp=%s, dataSize=%s", e.getMessage(), tag, timestamp, len));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] formatFromMessagePack(String tag, Object timestamp, ByteBuffer mapValue) {
        int mapValueLen = mapValue.remaining();
        try (MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((ByteBuffer)mapValue);){
            byte[] byArray = this.addTimeColumnToMsgpackRecord(unpacker, this.getEpoch(timestamp), mapValueLen);
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Failed to convert the record to MessagePack format: cause=%s, tag=%s, timestamp=%s, dataSize=%s", e.getMessage(), tag, timestamp, mapValueLen));
        }
    }

    public static class Config
    extends RecordFormatter.Config {
    }
}

