/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.treasuredata.ingester.sender;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import com.google.common.annotations.VisibleForTesting;
import com.treasuredata.client.TDClient;
import com.treasuredata.client.TDClientBuilder;
import com.treasuredata.client.TDClientHttpException;
import com.treasuredata.client.TDClientHttpNotFoundException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.komamitsu.fluency.NonRetryableException;
import org.komamitsu.fluency.RetryableException;
import org.komamitsu.fluency.ingester.sender.ErrorHandler;
import org.komamitsu.fluency.ingester.sender.Sender;
import org.komamitsu.fluency.validation.Validatable;
import org.komamitsu.fluency.validation.annotation.DecimalMin;
import org.komamitsu.fluency.validation.annotation.Min;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreasureDataSender
implements Closeable,
Sender {
    private static final Logger LOG = LoggerFactory.getLogger(TreasureDataSender.class);
    private static final int RETRY_COUNT_FOR_DB_CREATE_DELETE_CONFLICT = 4;
    private static final int RETRY_INTERVAL_MS_FOR_DB_CREATE_DELETE_CONFLICT = 1000;
    private final Config config;
    private final TDClient client;
    private final RetryPolicy retryPolicy;

    public TreasureDataSender() {
        this(new Config());
    }

    public TreasureDataSender(Config config) {
        config.validateValues();
        this.config = config;
        this.retryPolicy = ((RetryPolicy)new RetryPolicy().handleIf(ex -> {
            if (ex == null) {
                return false;
            }
            ErrorHandler errorHandler = config.getErrorHandler();
            if (errorHandler != null) {
                errorHandler.handle(ex);
            }
            return !(ex instanceof InterruptedException) && !(ex instanceof NonRetryableException);
        })).withBackoff((long)this.getRetryInternalMs(), (long)this.getMaxRetryInternalMs(), ChronoUnit.MILLIS, (double)this.getRetryFactor()).withMaxRetries(this.getRetryMax());
        this.client = this.buildClient();
    }

    @VisibleForTesting
    protected TDClient buildClient() {
        URI uri;
        try {
            uri = new URI(this.config.getEndpoint());
        }
        catch (URISyntaxException e) {
            throw new NonRetryableException(String.format("Invalid endpoint. %s", this.config.getEndpoint()), (Throwable)e);
        }
        String host = uri.getHost() != null ? uri.getHost() : this.config.getEndpoint();
        TDClientBuilder builder = (TDClientBuilder)((TDClientBuilder)((TDClientBuilder)((TDClientBuilder)((TDClientBuilder)((TDClientBuilder)new TDClientBuilder(false).setEndpoint(host)).setApiKey(this.config.getApikey())).setRetryLimit(this.config.getRetryMax())).setRetryInitialIntervalMillis(this.config.getRetryIntervalMs())).setRetryMaxIntervalMillis(this.config.getMaxRetryIntervalMs())).setRetryMultiplier((double)this.config.getRetryFactor());
        if (uri.getScheme() != null && uri.getScheme().equals("http")) {
            builder.setUseSSL(false);
        }
        if (uri.getPort() > 0) {
            builder.setPort(uri.getPort());
        }
        return builder.build();
    }

    public TDClient getClient() {
        return this.client;
    }

    public int getRetryInternalMs() {
        return this.config.getRetryIntervalMs();
    }

    public int getMaxRetryInternalMs() {
        return this.config.getMaxRetryIntervalMs();
    }

    public float getRetryFactor() {
        return this.config.getRetryFactor();
    }

    public int getRetryMax() {
        return this.config.getRetryMax();
    }

    public int getWorkBufSize() {
        return this.config.getWorkBufSize();
    }

    private void copyStreams(InputStream in, OutputStream out) throws IOException {
        int readLen;
        byte[] buf = new byte[this.getWorkBufSize()];
        while ((readLen = in.read(buf)) >= 0) {
            out.write(buf, 0, readLen);
        }
    }

    private boolean checkDatabaseAndWaitIfNeeded(String database) {
        if (this.client.existsDatabase(database)) {
            return true;
        }
        LOG.warn("The database could be just removed or invisible. Retrying.... database={}", (Object)database);
        try {
            TimeUnit.MILLISECONDS.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NonRetryableException(String.format("Failed to create database. database=%s", database), (Throwable)e);
        }
        return false;
    }

    private void createDatabase(String database) {
        for (int i = 0; i < 4; ++i) {
            try {
                this.client.createDatabase(database);
                LOG.info("Created database. database={}", (Object)database);
                return;
            }
            catch (TDClientHttpException e) {
                switch (e.getStatusCode()) {
                    case 409: {
                        LOG.info("The database already exists. database={}", (Object)database);
                        if (!this.checkDatabaseAndWaitIfNeeded(database)) break;
                        return;
                    }
                    case 401: 
                    case 403: 
                    case 404: {
                        throw new NonRetryableException(String.format("Failed to create database. database=%s", database), (Throwable)e);
                    }
                }
                continue;
            }
            catch (NonRetryableException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RetryableException(String.format("Failed to create database. database=%s", database), e);
            }
        }
        throw new NonRetryableException(String.format("It seems you don't have a proper permission on the database. database=%s", database));
    }

    /*
     * Loose catch block
     */
    private void createTable(String database, String table) {
        block9: while (true) {
            try {
                this.client.createTable(database, table);
                LOG.info("Created table. database={}, table={}", (Object)database, (Object)table);
                return;
            }
            catch (TDClientHttpException e) {
                switch (e.getStatusCode()) {
                    case 409: {
                        LOG.info("The table already exists. database={}, table={}", (Object)database, (Object)table);
                        return;
                    }
                    case 401: 
                    case 403: {
                        throw new NonRetryableException(String.format("Failed to create table. database=%s, table=%s", database, table), (Throwable)e);
                    }
                    case 404: {
                        this.createDatabase(database);
                        continue block9;
                    }
                }
                throw new RetryableException(String.format("Failed to create table. database=%s, table=%s", database, table), (Throwable)e);
            }
            catch (NonRetryableException e) {
                throw e;
            }
            break;
        }
        catch (Throwable e) {
            throw new RetryableException(String.format("Failed to create table. database=%s, table=%s", database, table), e);
        }
    }

    /*
     * Loose catch block
     */
    private void importData(String database, String table, String uniqueId, File file) {
        LOG.debug("Importing data to TD table: database={}, table={}, uniqueId={}, fileSize={}", new Object[]{database, table, uniqueId, file.length()});
        while (true) {
            try {
                this.client.importFile(database, table, file, uniqueId);
                return;
            }
            catch (TDClientHttpNotFoundException e) {
                this.createTable(database, table);
                continue;
            }
            catch (NonRetryableException e) {
                throw e;
            }
            break;
        }
        catch (Throwable e) {
            throw new RetryableException(String.format("Failed to import data. database=%s, table=%s", database, table), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(String dbAndTableTag, ByteBuffer dataBuffer) throws IOException {
        String[] dbAndTable = dbAndTableTag.split("\\.");
        String database = dbAndTable[0];
        String table = dbAndTable[1];
        File file = File.createTempFile("tmp-fluency-", ".msgpack.gz");
        try {
            try (ByteBufferBackedInputStream in = new ByteBufferBackedInputStream(dataBuffer);
                 GZIPOutputStream out = new GZIPOutputStream(Files.newOutputStream(file.toPath(), StandardOpenOption.WRITE));){
                this.copyStreams((InputStream)in, out);
            }
            String uniqueId = UUID.randomUUID().toString();
            Failsafe.with((Policy)this.retryPolicy, (Policy[])new RetryPolicy[0]).run(() -> this.importData(database, table, uniqueId, file));
        }
        finally {
            if (!file.delete()) {
                LOG.warn("Failed to delete a temp file: {}", (Object)file.getAbsolutePath());
            }
        }
    }

    @Override
    public void close() throws IOException {
    }

    public static class Config
    extends Sender.Config
    implements Validatable {
        private String endpoint = "https://api-import.treasuredata.com";
        private String apikey;
        @Min(value=10L)
        private int retryIntervalMs = 1000;
        @Min(value=10L)
        private int maxRetryIntervalMs = 30000;
        @DecimalMin(value="1.0")
        private float retryFactor = 2.0f;
        @Min(value=0L)
        private int retryMax = 10;
        @Min(value=1024L)
        private int workBufSize = 8192;

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getApikey() {
            return this.apikey;
        }

        public void setApikey(String apikey) {
            this.apikey = apikey;
        }

        public int getRetryIntervalMs() {
            return this.retryIntervalMs;
        }

        public void setRetryIntervalMs(int retryIntervalMs) {
            this.retryIntervalMs = retryIntervalMs;
        }

        public int getMaxRetryIntervalMs() {
            return this.maxRetryIntervalMs;
        }

        public void setMaxRetryIntervalMs(int maxRetryIntervalMs) {
            this.maxRetryIntervalMs = maxRetryIntervalMs;
        }

        public float getRetryFactor() {
            return this.retryFactor;
        }

        public void setRetryFactor(float retryFactor) {
            this.retryFactor = retryFactor;
        }

        public int getRetryMax() {
            return this.retryMax;
        }

        public void setRetryMax(int retryMax) {
            this.retryMax = retryMax;
        }

        public int getWorkBufSize() {
            return this.workBufSize;
        }

        public void setWorkBufSize(int workBufSize) {
            this.workBufSize = workBufSize;
        }

        public String toString() {
            return "Config{endpoint='" + this.endpoint + '\'' + ", retryIntervalMs=" + this.retryIntervalMs + ", maxRetryIntervalMs=" + this.maxRetryIntervalMs + ", retryFactor=" + this.retryFactor + ", retryMax=" + this.retryMax + ", workBufSize=" + this.workBufSize + "} " + super.toString();
        }

        void validateValues() {
            this.validate();
        }
    }
}

