/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.buffer.PackedForwardBuffer;
import org.komamitsu.fluency.flusher.AsyncFlusher;
import org.komamitsu.fluency.flusher.Flusher;
import org.komamitsu.fluency.sender.MultiSender;
import org.komamitsu.fluency.sender.RetryableSender;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.TCPSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fluency
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Fluency.class);
    private final Buffer buffer;
    private final Flusher flusher;

    public static Fluency defaultFluency(String host, int port) throws IOException {
        return new Builder(new RetryableSender(new TCPSender(host, port))).build();
    }

    public static Fluency defaultFluency(int port) throws IOException {
        return Fluency.defaultFluency("127.0.0.1", port);
    }

    public static Fluency defaultFluency() throws IOException {
        return Fluency.defaultFluency("127.0.0.1", 24224);
    }

    public static Fluency defaultFluency(List<InetSocketAddress> servers) throws IOException {
        ArrayList<TCPSender> tcpSenders = new ArrayList<TCPSender>();
        for (InetSocketAddress server : servers) {
            tcpSenders.add(new TCPSender(server.getHostName(), server.getPort()));
        }
        return new Builder(new RetryableSender(new MultiSender(tcpSenders))).build();
    }

    private Fluency(Buffer buffer, Flusher flusher) {
        this.buffer = buffer;
        this.flusher = flusher;
    }

    public void emit(String tag, long timestamp, Map<String, Object> data) throws IOException {
        this.buffer.append(tag, timestamp, data);
        this.flusher.onUpdate();
    }

    public void emit(String tag, Map<String, Object> data) throws IOException {
        this.emit(tag, System.currentTimeMillis() / 1000L, data);
    }

    @Override
    public void flush() throws IOException {
        this.flusher.flush();
    }

    @Override
    public void close() throws IOException {
        this.flusher.close();
    }

    public static class Builder {
        private final Sender sender;
        private Buffer.Config bufferConfig;
        private Flusher.Config flusherConfig;

        public Builder(Sender sender) {
            this.sender = sender;
        }

        public Builder setBufferConfig(Buffer.Config bufferConfig) {
            this.bufferConfig = bufferConfig;
            return this;
        }

        public Builder setFlusherConfig(Flusher.Config flusherConfig) {
            this.flusherConfig = flusherConfig;
            return this;
        }

        public Fluency build() {
            Buffer.Config bufferConfig = this.bufferConfig != null ? this.bufferConfig : new PackedForwardBuffer.Config();
            Object buffer = bufferConfig.createInstance();
            Flusher.Config flusherConfig = this.flusherConfig != null ? this.flusherConfig : new AsyncFlusher.Config();
            Object flusher = flusherConfig.createInstance((Buffer)buffer, this.sender);
            return new Fluency((Buffer)buffer, (Flusher)flusher);
        }
    }
}

