/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.retry;

import org.komamitsu.fluency.sender.retry.RetryStrategy;

public class ExponentialBackOffRetryStrategy
extends RetryStrategy<Config> {
    public ExponentialBackOffRetryStrategy(Config config) {
        super(config);
    }

    @Override
    public long getNextIntervalMillis(int retryCount) {
        long interval = ((Config)this.config).getBaseIntervalMillis() * (long)((int)Math.pow(2.0, retryCount));
        if (interval > ((Config)this.config).getMaxIntervalMillis()) {
            return ((Config)this.config).getMaxIntervalMillis();
        }
        return interval;
    }

    public static class Config
    extends RetryStrategy.Config<Config> {
        private long baseIntervalMillis = 400L;
        private long maxIntervalMillis = 30L;

        public long getBaseIntervalMillis() {
            return this.baseIntervalMillis;
        }

        public Config setBaseIntervalMillis(long baseIntervalMillis) {
            this.baseIntervalMillis = baseIntervalMillis;
            return this;
        }

        public long getMaxIntervalMillis() {
            return this.maxIntervalMillis;
        }

        public Config setMaxIntervalMillis(long maxIntervalMillis) {
            this.maxIntervalMillis = maxIntervalMillis;
            return this;
        }
    }
}

