/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.buffer;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.komamitsu.fluency.sender.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Buffer<T extends Config> {
    private static final Logger LOG = LoggerFactory.getLogger(Buffer.class);
    protected final T bufferConfig;
    protected final AtomicInteger totalSize = new AtomicInteger();

    public Buffer(T bufferConfig) {
        this.bufferConfig = bufferConfig;
    }

    public abstract void append(String var1, long var2, Map<String, Object> var4) throws IOException;

    public void flush(Sender sender) throws IOException {
        LOG.trace("flush(): bufferUsage={}", (Object)Float.valueOf(this.getBufferUsage()));
        this.flushInternal(sender);
    }

    public abstract void flushInternal(Sender var1) throws IOException;

    public void close(Sender sender) throws IOException {
        this.closeInternal(sender);
    }

    protected abstract void closeInternal(Sender var1) throws IOException;

    public int getTotalSize() {
        return this.totalSize.get();
    }

    public int getMaxSize() {
        return ((Config)this.bufferConfig).getBufferSize();
    }

    public float getBufferUsage() {
        return (float)this.getTotalSize() / (float)this.getMaxSize();
    }

    public static abstract class Config<T extends Buffer, C extends Config> {
        protected int bufferSize = 0x1000000;

        public int getBufferSize() {
            return this.bufferSize;
        }

        public C setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return (C)this;
        }

        public String toString() {
            return "Config{bufferSize=" + this.bufferSize + '}';
        }

        public abstract T createInstance();
    }

    public static class BufferFullException
    extends IOException {
        public BufferFullException(String s) {
            super(s);
        }
    }
}

