/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.sender.Sender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Flusher
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Flusher.class);
    protected final Buffer buffer;
    protected final Sender sender;
    protected final Config flusherConfig;

    public Flusher(Buffer buffer, Sender sender, Config flusherConfig) {
        this.buffer = buffer;
        this.sender = sender;
        this.flusherConfig = flusherConfig;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    protected abstract void flushInternal(boolean var1) throws IOException;

    protected abstract void closeInternal() throws IOException;

    public void onUpdate() throws IOException {
        this.flushInternal(false);
    }

    @Override
    public void flush() throws IOException {
        this.flushInternal(true);
    }

    @Override
    public void close() throws IOException {
        this.closeInternal();
    }

    protected void closeBuffer() {
        LOG.trace("closeBuffer(): closing buffer");
        try {
            this.buffer.close(this.sender);
        }
        catch (IOException e) {
            LOG.warn("Interrupted during closing buffer");
        }
        LOG.trace("closeBuffer(): closed buffer");
    }

    public static abstract class Config<T extends Flusher> {
        private int flushIntervalMillis = 600;
        private float bufferOccupancyThreshold = 0.6f;

        public int getFlushIntervalMillis() {
            return this.flushIntervalMillis;
        }

        public Config setFlushIntervalMillis(int flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return this;
        }

        public float getBufferOccupancyThreshold() {
            return this.bufferOccupancyThreshold;
        }

        public Config setBufferOccupancyThreshold(float bufferOccupancyThreshold) {
            this.bufferOccupancyThreshold = bufferOccupancyThreshold;
            return this;
        }

        public abstract T createInstance(Buffer var1, Sender var2);
    }
}

