/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.flusher;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.flusher.Flusher;
import org.komamitsu.fluency.sender.Sender;

public class SyncFlusher
extends Flusher {
    private final AtomicLong lastFlushTimeMillis = new AtomicLong();

    private SyncFlusher(Buffer buffer, Sender sender, Config flusherConfig) {
        super(buffer, sender, flusherConfig);
    }

    @Override
    protected void flushInternal(boolean force) throws IOException {
        long now = System.currentTimeMillis();
        if (force || now > this.lastFlushTimeMillis.get() + (long)this.flusherConfig.getFlushIntervalMillis() || this.buffer.getBufferUsage() > this.flusherConfig.getBufferOccupancyThreshold()) {
            this.buffer.flush(this.sender);
            this.lastFlushTimeMillis.set(now);
        }
    }

    @Override
    protected void closeInternal() throws IOException {
        this.flushInternal(true);
        this.closeBuffer();
    }

    public static class Config
    extends Flusher.Config<SyncFlusher> {
        @Override
        public SyncFlusher createInstance(Buffer buffer, Sender sender) {
            return new SyncFlusher(buffer, sender, this);
        }
    }
}

