/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.failuredetect;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.fluency.sender.failuredetect.FailureDetectStrategy;
import org.komamitsu.fluency.sender.heartbeat.Heartbeater;

public class FailureDetector
implements Heartbeater.Callback,
Closeable {
    private final FailureDetectStrategy failureDetectStrategy;
    private final Heartbeater heartbeater;
    private final AtomicReference<Long> lastFailureTimestampMillis = new AtomicReference();

    private FailureDetector(FailureDetectStrategy failureDetectStrategy, Heartbeater heartbeater) {
        this.failureDetectStrategy = failureDetectStrategy;
        this.heartbeater = heartbeater;
        this.heartbeater.setCallback(this);
    }

    public FailureDetector(FailureDetectStrategy.Config failureDetectorStrategyConfig, Heartbeater.Config heartbeaterConfig) throws IOException {
        this(failureDetectorStrategyConfig.createInstance(), heartbeaterConfig.createInstance());
    }

    public FailureDetectStrategy getFailureDetectStrategy() {
        return this.failureDetectStrategy;
    }

    public Heartbeater getHeartbeater() {
        return this.heartbeater;
    }

    @Override
    public void onHeartbeat() {
        this.failureDetectStrategy.heartbeat(System.currentTimeMillis());
    }

    @Override
    public void onFailure(Throwable cause) {
        this.lastFailureTimestampMillis.set(System.currentTimeMillis());
    }

    public boolean isAvailable() {
        Long failureTimestamp = this.lastFailureTimestampMillis.get();
        if (failureTimestamp != null) {
            if (failureTimestamp > System.currentTimeMillis() - 3000L) {
                return false;
            }
            this.lastFailureTimestampMillis.set(null);
        }
        return this.failureDetectStrategy.isAvailable();
    }

    @Override
    public void close() throws IOException {
        this.heartbeater.close();
    }
}

