/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.retry.ExponentialBackOffRetryStrategy;
import org.komamitsu.fluency.sender.retry.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableSender
implements Sender {
    private static final Logger LOG = LoggerFactory.getLogger(RetryableSender.class);
    private final RetryStrategy retryStrategy;
    private final Sender baseSender;

    @Override
    public void close() throws IOException {
        this.baseSender.close();
    }

    public RetryableSender(Sender baseSender, RetryStrategy retryStrategy) {
        this.baseSender = baseSender;
        this.retryStrategy = retryStrategy;
    }

    public RetryableSender(Sender baseSender) {
        this(baseSender, new ExponentialBackOffRetryStrategy.Config().createInstance());
    }

    @Override
    public void send(ByteBuffer data) throws IOException {
        IOException firstException = null;
        int retry = 0;
        while (!this.retryStrategy.isRetriedOver(retry)) {
            try {
                this.baseSender.send(data);
                return;
            }
            catch (IOException e) {
                firstException = e;
                LOG.warn("Sender failed to send data. sender=" + this + ", retry=" + retry, (Throwable)e);
                try {
                    TimeUnit.MILLISECONDS.sleep(this.retryStrategy.getNextIntervalMillis(retry));
                }
                catch (InterruptedException e2) {
                    LOG.debug("Interrupted while waiting", (Throwable)e2);
                    Thread.currentThread().interrupt();
                }
                ++retry;
            }
        }
        throw new RetryOverException("Sending data was retried over", firstException);
    }

    public static class RetryOverException
    extends IOException {
        public RetryOverException(String s, Throwable throwable) {
            super(s, throwable);
        }
    }
}

