/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.heartbeat;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.komamitsu.fluency.flusher.AsyncFlusher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Heartbeater
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncFlusher.class);
    protected final Config config;
    private final ScheduledExecutorService executorService;
    private final AtomicReference<Callback> callback = new AtomicReference();

    protected Heartbeater(Config config) {
        this.config = config;
        this.executorService = Executors.newScheduledThreadPool(1);
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Heartbeater.this.ping();
            }
        }, config.getIntervalMillis(), config.getIntervalMillis(), TimeUnit.MILLISECONDS);
    }

    public String getHost() {
        return this.config.getHost();
    }

    public int getPort() {
        return this.config.getPort();
    }

    protected abstract void invoke() throws IOException;

    protected void ping() {
        block2: {
            try {
                this.invoke();
            }
            catch (Throwable e) {
                LOG.warn("ping(): failed, config=" + this.config, e);
                Callback callback = this.callback.get();
                if (callback == null) break block2;
                callback.onFailure(e);
            }
        }
    }

    protected void pong() {
        Callback callback = this.callback.get();
        if (callback != null) {
            callback.onHeartbeat();
        }
    }

    public void setCallback(Callback callback) {
        this.callback.set(callback);
    }

    @Override
    public void close() throws IOException {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("1st awaitTermination was interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        if (!this.executorService.isTerminated()) {
            this.executorService.shutdownNow();
        }
    }

    public static abstract class Config<C extends Config> {
        private String host = "127.0.0.1";
        private int port = 24224;
        private int intervalMillis = 1000;

        public String getHost() {
            return this.host;
        }

        public C setHost(String host) {
            this.host = host;
            return (C)this;
        }

        public int getPort() {
            return this.port;
        }

        public C setPort(int port) {
            this.port = port;
            return (C)this;
        }

        public int getIntervalMillis() {
            return this.intervalMillis;
        }

        public C setIntervalMillis(int intervalMillis) {
            this.intervalMillis = intervalMillis;
            return (C)this;
        }

        public String toString() {
            return "Config{host='" + this.host + '\'' + ", port=" + this.port + ", intervalMillis=" + this.intervalMillis + '}';
        }

        public abstract Heartbeater createInstance() throws IOException;

        public abstract C dupDefaultConfig();
    }

    public static interface Callback {
        public void onHeartbeat();

        public void onFailure(Throwable var1);
    }
}

