/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.komamitsu.fluency.buffer.Buffer;
import org.komamitsu.fluency.buffer.PackedForwardBuffer;
import org.komamitsu.fluency.flusher.AsyncFlusher;
import org.komamitsu.fluency.flusher.Flusher;
import org.komamitsu.fluency.sender.MultiSender;
import org.komamitsu.fluency.sender.RetryableSender;
import org.komamitsu.fluency.sender.Sender;
import org.komamitsu.fluency.sender.TCPSender;
import org.komamitsu.fluency.sender.retry.ExponentialBackOffRetryStrategy;
import org.komamitsu.fluency.sender.retry.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fluency
implements Flushable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Fluency.class);
    private final Buffer buffer;
    private final Flusher flusher;

    public static Fluency defaultFluency(String host, int port, Config config) throws IOException {
        return Fluency.buildDefaultFluency(new TCPSender(host, port), config);
    }

    private static Fluency buildDefaultFluency(Sender sender, Config config) {
        PackedForwardBuffer.Config bufferConfig = new PackedForwardBuffer.Config();
        if (config != null && config.getMaxBufferSize() != null) {
            bufferConfig.setMaxBufferSize(config.getMaxBufferSize());
        }
        if (config != null) {
            bufferConfig.setAckResponseMode(config.ackResponseMode);
        }
        AsyncFlusher.Config flusherConfig = new AsyncFlusher.Config();
        if (config != null && config.getFlushIntervalMillis() != null) {
            flusherConfig.setFlushIntervalMillis(config.getFlushIntervalMillis());
        }
        ExponentialBackOffRetryStrategy.Config retryStrategyConfig = new ExponentialBackOffRetryStrategy.Config();
        if (config != null && config.getSenderMaxRetryCount() != null) {
            retryStrategyConfig.setMaxRetryCount(config.getSenderMaxRetryCount());
        }
        Object retryStrategy = retryStrategyConfig.createInstance();
        return new Builder(new RetryableSender(sender, (RetryStrategy)retryStrategy)).setBufferConfig(bufferConfig).setFlusherConfig(flusherConfig).build();
    }

    public static Fluency defaultFluency(int port, Config config) throws IOException {
        return Fluency.defaultFluency("127.0.0.1", port, config);
    }

    public static Fluency defaultFluency(Config config) throws IOException {
        return Fluency.defaultFluency("127.0.0.1", 24224, config);
    }

    public static Fluency defaultFluency(List<InetSocketAddress> servers, Config config) throws IOException {
        ArrayList<TCPSender> tcpSenders = new ArrayList<TCPSender>();
        for (InetSocketAddress server : servers) {
            tcpSenders.add(new TCPSender(server.getHostName(), server.getPort()));
        }
        return Fluency.buildDefaultFluency(new MultiSender(tcpSenders), config);
    }

    public static Fluency defaultFluency(String host, int port) throws IOException {
        return Fluency.defaultFluency(host, port, null);
    }

    public static Fluency defaultFluency(int port) throws IOException {
        return Fluency.defaultFluency(port, null);
    }

    public static Fluency defaultFluency() throws IOException {
        return Fluency.defaultFluency("127.0.0.1", 24224);
    }

    public static Fluency defaultFluency(List<InetSocketAddress> servers) throws IOException {
        return Fluency.defaultFluency(servers, null);
    }

    private Fluency(Buffer buffer, Flusher flusher) {
        this.buffer = buffer;
        this.flusher = flusher;
    }

    public void emit(String tag, long timestamp, Map<String, Object> data) throws IOException {
        while (true) {
            try {
                this.buffer.append(tag, timestamp, data);
                this.flusher.onUpdate();
            }
            catch (Buffer.BufferFullException e) {
                LOG.warn("emit() failed due to buffer full. retrying...");
                try {
                    this.flusher.flush();
                    TimeUnit.MILLISECONDS.sleep(400L);
                }
                catch (InterruptedException e1) {
                    LOG.warn("Interrupted during retrying", (Throwable)e1);
                    Thread.currentThread().interrupt();
                }
                continue;
            }
            break;
        }
    }

    public void emit(String tag, Map<String, Object> data) throws IOException {
        this.emit(tag, System.currentTimeMillis() / 1000L, data);
    }

    @Override
    public void flush() throws IOException {
        this.flusher.flush();
    }

    @Override
    public void close() throws IOException {
        this.flusher.close();
    }

    public static class Config {
        private Integer maxBufferSize;
        private Integer flushIntervalMillis;
        private Integer senderMaxRetryCount;
        private boolean ackResponseMode;

        public Integer getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public Config setMaxBufferSize(Integer maxBufferSize) {
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public Integer getFlushIntervalMillis() {
            return this.flushIntervalMillis;
        }

        public Config setFlushIntervalMillis(Integer flushIntervalMillis) {
            this.flushIntervalMillis = flushIntervalMillis;
            return this;
        }

        public Integer getSenderMaxRetryCount() {
            return this.senderMaxRetryCount;
        }

        public Config setSenderMaxRetryCount(Integer senderMaxRetryCount) {
            this.senderMaxRetryCount = senderMaxRetryCount;
            return this;
        }

        public boolean isAckResponseMode() {
            return this.ackResponseMode;
        }

        public Config setAckResponseMode(boolean ackResponseMode) {
            this.ackResponseMode = ackResponseMode;
            return this;
        }
    }

    public static class Builder {
        private final Sender sender;
        private Buffer.Config bufferConfig;
        private Flusher.Config flusherConfig;

        public Builder(Sender sender) {
            this.sender = sender;
        }

        public Builder setBufferConfig(Buffer.Config bufferConfig) {
            this.bufferConfig = bufferConfig;
            return this;
        }

        public Builder setFlusherConfig(Flusher.Config flusherConfig) {
            this.flusherConfig = flusherConfig;
            return this;
        }

        public Fluency build() {
            Buffer.Config bufferConfig = this.bufferConfig != null ? this.bufferConfig : new PackedForwardBuffer.Config();
            Object buffer = bufferConfig.createInstance();
            Flusher.Config flusherConfig = this.flusherConfig != null ? this.flusherConfig : new AsyncFlusher.Config();
            Object flusher = flusherConfig.createInstance((Buffer)buffer, this.sender);
            return new Fluency((Buffer)buffer, (Flusher)flusher);
        }
    }
}

