/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.sender.failuredetect;

import org.komamitsu.failuredetector.PhiAccuralFailureDetector;
import org.komamitsu.fluency.sender.failuredetect.FailureDetectStrategy;

public class PhiAccrualFailureDetectStrategy
extends FailureDetectStrategy {
    private final PhiAccuralFailureDetector failureDetector;

    private PhiAccrualFailureDetectStrategy(Config config) {
        super(config);
        this.failureDetector = new PhiAccuralFailureDetector.Builder().setThreshold(config.getPhiThreshold()).setMaxSampleSize(config.getArrivalWindowSize()).build();
    }

    @Override
    public void heartbeat(long now) {
        this.failureDetector.heartbeat(now);
    }

    @Override
    public boolean isAvailable() {
        return this.failureDetector.isAvailable();
    }

    public static class Config
    extends FailureDetectStrategy.Config {
        private double phiThreshold = 16.0;
        private int arrivalWindowSize = 100;

        public double getPhiThreshold() {
            return this.phiThreshold;
        }

        public Config setPhiThreshold(float phiThreshold) {
            this.phiThreshold = phiThreshold;
            return this;
        }

        public int getArrivalWindowSize() {
            return this.arrivalWindowSize;
        }

        public Config setArrivalWindowSize(int arrivalWindowSize) {
            this.arrivalWindowSize = arrivalWindowSize;
            return this;
        }

        @Override
        public FailureDetectStrategy createInstance() {
            return new PhiAccrualFailureDetectStrategy(this);
        }
    }
}

